/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.commands;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.commands.CommandHandler;
import dev.doeshing.koukeNekoNametag.commands.CreateTagCommandHandler;
import dev.doeshing.koukeNekoNametag.commands.PlayerTagCommandHandler;
import dev.doeshing.koukeNekoNametag.commands.RemoveTagCommandHandler;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagManager;
import dev.doeshing.koukeNekoNametag.core.tag.TagMenu;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TagCommand
implements CommandExecutor,
TabCompleter {
    private final KoukeNekoNametag plugin;
    private final TagManager tagManager;
    private final TagMenu tagMenu;
    private final List<CommandHandler> commandHandlers;

    public TagCommand(KoukeNekoNametag plugin, TagManager tagManager, TagMenu tagMenu) {
        this.plugin = plugin;
        this.tagManager = tagManager;
        this.tagMenu = tagMenu;
        this.commandHandlers = this.initializeCommandHandlers();
    }

    private List<CommandHandler> initializeCommandHandlers() {
        ArrayList<CommandHandler> handlers = new ArrayList<CommandHandler>();
        handlers.add(new CreateTagCommandHandler(this.plugin, this.tagManager));
        handlers.add(new RemoveTagCommandHandler(this.plugin, this.tagManager));
        handlers.add(new PlayerTagCommandHandler(this.plugin, this.tagManager));
        return handlers;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            return this.handleMenuOpen(sender);
        }
        if (!this.hasAdminPermission(sender)) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "error.no_permission");
            return true;
        }
        for (CommandHandler handler : this.commandHandlers) {
            if (!handler.canHandle(args)) continue;
            return handler.handle(sender, args);
        }
        this.plugin.getMessageManager().sendConfigMessage(sender, "tag.help");
        return true;
    }

    private boolean handleMenuOpen(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "error.player_only");
            return true;
        }
        Player player = (Player)sender;
        this.tagMenu.openMenu(player);
        return true;
    }

    private boolean hasAdminPermission(CommandSender sender) {
        String adminPermission = this.plugin.getConfig().getString("permission.admin", "koukeneko.admin");
        return sender.hasPermission(adminPermission);
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!this.hasAdminPermission(sender)) {
            return completions;
        }
        return this.generateTabCompletions(args);
    }

    private List<String> generateTabCompletions(String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            return this.getFirstArgumentCompletions(args[0]);
        }
        if (args.length == 2) {
            return this.getSecondArgumentCompletions(args);
        }
        if (args.length == 3) {
            return this.getThirdArgumentCompletions(args);
        }
        return completions;
    }

    private List<String> getFirstArgumentCompletions(String input) {
        ArrayList<String> completions = new ArrayList<String>();
        if ("create".startsWith(input.toLowerCase())) {
            completions.add("create");
        }
        if ("remove".startsWith(input.toLowerCase())) {
            completions.add("remove");
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().toLowerCase().startsWith(input.toLowerCase())) continue;
            completions.add(player.getName());
        }
        return completions;
    }

    private List<String> getSecondArgumentCompletions(String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if ("create".equalsIgnoreCase(args[0])) {
            return completions;
        }
        if ("remove".equalsIgnoreCase(args[0])) {
            for (Tag tag : this.tagManager.getAllTags()) {
                if (!tag.getId().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                completions.add(tag.getId());
            }
            return completions;
        }
        List<String> actions = List.of("add", "remove");
        for (String action : actions) {
            if (!action.startsWith(args[1].toLowerCase())) continue;
            completions.add(action);
        }
        return completions;
    }

    private List<String> getThirdArgumentCompletions(String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!"create".equalsIgnoreCase(args[0]) && ("add".equalsIgnoreCase(args[1]) || "remove".equalsIgnoreCase(args[1]))) {
            for (Tag tag : this.tagManager.getAllTags()) {
                if (!tag.getId().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                completions.add(tag.getId());
            }
        }
        return completions;
    }
}

