/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core.tag;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagDisplayService;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTagDisplayService
implements TagDisplayService {
    private final KoukeNekoNametag plugin;

    public CommandTagDisplayService(KoukeNekoNametag plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean setActiveTag(Player player, Tag tag) {
        if (tag == null) {
            return false;
        }
        List commands = this.plugin.getConfig().getStringList("command.settag");
        return this.executeDisplayCommands(commands, player, tag.getDisplay());
    }

    @Override
    public boolean removeActiveTag(Player player) {
        List commands = this.plugin.getConfig().getStringList("command.remove");
        return this.executeDisplayCommands(commands, player, null);
    }

    private boolean executeDisplayCommands(List<String> commands, Player player, String tagDisplay) {
        boolean logCommands = this.plugin.getConfig().getBoolean("debug.log_commands", true);
        for (String cmd : commands) {
            cmd = cmd.replace("{player}", player.getName());
            if (tagDisplay != null) {
                cmd = cmd.replace("{tag}", tagDisplay);
            }
            if (logCommands) {
                this.plugin.getLogger().info("\u57f7\u884c\u986f\u793a\u6307\u4ee4: " + cmd);
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
        return true;
    }
}

