/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core.tag;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagPermissionService;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTagPermissionService
implements TagPermissionService {
    private final KoukeNekoNametag plugin;

    public CommandTagPermissionService(KoukeNekoNametag plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean givePermission(Player player, Tag tag) {
        if (tag == null) {
            return false;
        }
        return this.executePermissionCommands("command.add_permission", player, tag);
    }

    @Override
    public boolean removePermission(Player player, Tag tag) {
        if (tag == null) {
            return false;
        }
        return this.executePermissionCommands("command.remove_permission", player, tag);
    }

    @Override
    public boolean hasPermission(Player player, Tag tag) {
        return player.hasPermission(tag.getPermission());
    }

    private boolean executePermissionCommands(String configPath, Player player, Tag tag) {
        List commands = this.plugin.getConfig().getStringList(configPath);
        boolean logCommands = this.plugin.getConfig().getBoolean("debug.log_commands", true);
        for (String cmd : commands) {
            cmd = cmd.replace("{player}", player.getName()).replace("{tag}", tag.getPermission());
            if (logCommands) {
                this.plugin.getLogger().info("\u57f7\u884c\u6b0a\u9650\u6307\u4ee4: " + cmd);
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
        return true;
    }
}

