/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core.tag;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileTagRepository
implements TagRepository {
    private final KoukeNekoNametag plugin;
    private final Map<String, Tag> tags;
    private File tagsFile;
    private FileConfiguration tagsConfig;
    private String permissionPrefix;

    public FileTagRepository(KoukeNekoNametag plugin) {
        this.plugin = plugin;
        this.tags = new HashMap<String, Tag>();
        this.permissionPrefix = plugin.getConfig().getString("permission.tag_prefix", "koukeneko.tags.");
        this.initializeFile();
        this.loadAllTags();
    }

    private void initializeFile() {
        String tagsFileName = this.plugin.getConfig().getString("files.tags_file", "tags.yml");
        this.tagsFile = new File(this.plugin.getDataFolder(), tagsFileName);
        if (!this.tagsFile.exists()) {
            this.plugin.saveResource(tagsFileName, false);
        }
        this.tagsConfig = YamlConfiguration.loadConfiguration((File)this.tagsFile);
    }

    @Override
    public Collection<Tag> loadAllTags() {
        this.tags.clear();
        ConfigurationSection tagsSection = this.tagsConfig.getConfigurationSection("tags");
        if (tagsSection == null) {
            this.plugin.getLogger().warning("No tags section found in tags.yml!");
            return new ArrayList<Tag>();
        }
        for (String tagId : tagsSection.getKeys(false)) {
            String display = tagsSection.getString(tagId + ".display", "&7[" + tagId + "]&f");
            Tag tag = new Tag(tagId, display, this.permissionPrefix);
            this.tags.put(tagId, tag);
            if (!this.plugin.getConfig().getBoolean("debug.enabled", false)) continue;
            this.plugin.getLogger().info("Loaded tag: " + tagId + " with display: " + display);
        }
        return new ArrayList<Tag>(this.tags.values());
    }

    @Override
    public Optional<Tag> findById(String id) {
        return Optional.ofNullable(this.tags.get(id));
    }

    @Override
    public boolean save(Tag tag) {
        try {
            this.tags.put(tag.getId(), tag);
            this.tagsConfig.set("tags." + tag.getId() + ".display", (Object)tag.getDisplay());
            this.tagsConfig.save(this.tagsFile);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save tag: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean delete(String id) {
        if (!this.tags.containsKey(id)) {
            return false;
        }
        try {
            this.tags.remove(id);
            this.tagsConfig.set("tags." + id, null);
            this.tagsConfig.save(this.tagsFile);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to delete tag: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void reload() {
        this.permissionPrefix = this.plugin.getConfig().getString("permission.tag_prefix", "koukeneko.tags.");
        this.initializeFile();
        this.loadAllTags();
    }
}

