/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core.tag;

import java.util.Objects;

public final class Tag {
    private final String id;
    private final String display;
    private final String permissionPrefix;

    public Tag(String id, String display, String permissionPrefix) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("Tag ID cannot be null or empty");
        }
        if (display == null) {
            throw new IllegalArgumentException("Tag display cannot be null");
        }
        if (permissionPrefix == null) {
            throw new IllegalArgumentException("Permission prefix cannot be null");
        }
        this.id = id.trim();
        this.display = display;
        this.permissionPrefix = permissionPrefix;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getPermission() {
        return this.permissionPrefix + this.id;
    }

    public static boolean isValidId(String tagId) {
        return tagId != null && !tagId.trim().isEmpty() && tagId.matches("[a-zA-Z0-9_-]+");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tag tag = (Tag)obj;
        return Objects.equals(this.id, tag.id) && Objects.equals(this.display, tag.display) && Objects.equals(this.permissionPrefix, tag.permissionPrefix);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.display, this.permissionPrefix);
    }

    public String toString() {
        return String.format("Tag{id='%s', display='%s', permission='%s'}", this.id, this.display, this.getPermission());
    }
}

