/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core.tag;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagDisplayService;
import dev.doeshing.koukeNekoNametag.core.tag.TagPermissionService;
import dev.doeshing.koukeNekoNametag.core.tag.TagRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Player;

public class TagManager {
    private final KoukeNekoNametag plugin;
    private final TagRepository tagRepository;
    private final TagPermissionService permissionService;
    private final TagDisplayService displayService;

    public TagManager(KoukeNekoNametag plugin, TagRepository tagRepository, TagPermissionService permissionService, TagDisplayService displayService) {
        this.plugin = plugin;
        this.tagRepository = tagRepository;
        this.permissionService = permissionService;
        this.displayService = displayService;
    }

    public void reload() {
        this.tagRepository.reload();
    }

    public Collection<Tag> getAllTags() {
        return this.tagRepository.loadAllTags();
    }

    public Tag getTag(String id) {
        return this.tagRepository.findById(id).orElse(null);
    }

    public Tag createTag(String id, String display) {
        String permissionPrefix = this.plugin.getConfig().getString("permission.tag_prefix", "koukeneko.tags.");
        Tag tag = new Tag(id, display, permissionPrefix);
        if (this.tagRepository.save(tag)) {
            return tag;
        }
        return null;
    }

    public boolean deleteTag(String id) {
        return this.tagRepository.delete(id);
    }

    public List<Tag> getAvailableTags(Player player) {
        ArrayList<Tag> availableTags = new ArrayList<Tag>();
        for (Tag tag : this.getAllTags()) {
            if (!this.permissionService.hasPermission(player, tag)) continue;
            availableTags.add(tag);
        }
        return availableTags;
    }

    public boolean setActiveTag(Player player, Tag tag) {
        if (tag == null) {
            return false;
        }
        if (!this.permissionService.hasPermission(player, tag)) {
            return false;
        }
        this.displayService.removeActiveTag(player);
        return this.displayService.setActiveTag(player, tag);
    }

    public boolean removeActiveTag(Player player) {
        return this.displayService.removeActiveTag(player);
    }

    public boolean giveTagPermission(Player player, Tag tag) {
        return this.permissionService.givePermission(player, tag);
    }

    public boolean removeTagPermission(Player player, Tag tag) {
        return this.permissionService.removePermission(player, tag);
    }
}

