/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core.tag;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TagMenu
implements Listener {
    private final KoukeNekoNametag plugin;
    private final TagManager tagManager;
    private final Map<UUID, Inventory> openMenus = new HashMap<UUID, Inventory>();
    private final Map<UUID, List<Tag>> menuTags = new HashMap<UUID, List<Tag>>();

    public TagMenu(KoukeNekoNametag plugin, TagManager tagManager) {
        this.plugin = plugin;
        this.tagManager = tagManager;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openMenu(Player player) {
        List<Tag> availableTags = this.tagManager.getAvailableTags(player);
        if (availableTags.isEmpty()) {
            this.plugin.getMessageManager().sendConfigMessage((CommandSender)player, "menu.no_tags");
            return;
        }
        Inventory menu = this.createMenuInventory(availableTags);
        this.populateMenu(menu, availableTags, player);
        this.addRemoveButton(menu);
        this.registerMenu(player, menu, availableTags);
        player.openInventory(menu);
    }

    private Inventory createMenuInventory(List<Tag> availableTags) {
        int rows = Math.min(6, (availableTags.size() + 8) / 9 + 1);
        TextComponent title = LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getMessageManager().getMessage("menu.title"));
        return Bukkit.createInventory(null, (int)(rows * 9), (Component)title);
    }

    private void addRemoveButton(Inventory menu) {
        ItemStack removeItem = new ItemStack(Material.BARRIER);
        ItemMeta removeMeta = removeItem.getItemMeta();
        removeMeta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getMessageManager().getMessage("menu.remove_button")));
        removeItem.setItemMeta(removeMeta);
        menu.setItem(menu.getSize() - 1, removeItem);
    }

    private void registerMenu(Player player, Inventory menu, List<Tag> availableTags) {
        this.openMenus.put(player.getUniqueId(), menu);
        this.menuTags.put(player.getUniqueId(), availableTags);
    }

    private void populateMenu(Inventory menu, List<Tag> tags, Player player) {
        for (int i = 0; i < tags.size(); ++i) {
            Tag tag = tags.get(i);
            ItemStack item = this.createTagMenuItem(tag, player);
            menu.setItem(i, item);
        }
    }

    private ItemStack createTagMenuItem(Tag tag, Player player) {
        ItemStack item = new ItemStack(Material.NAME_TAG);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(tag.getDisplay()));
        meta.lore(this.createTagItemLore(tag, player));
        item.setItemMeta(meta);
        return item;
    }

    private List<Component> createTagItemLore(Tag tag, Player player) {
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getMessageManager().getMessage("menu.select_tag")));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("id", tag.getId());
        lore.add((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getMessageManager().getMessage("menu.tag_id", placeholders)));
        if (this.hasAdminPermission(player)) {
            placeholders.clear();
            placeholders.put("permission", tag.getPermission());
            lore.add((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getMessageManager().getMessage("menu.tag_permission", placeholders)));
        }
        return lore;
    }

    private boolean hasAdminPermission(Player player) {
        return player.hasPermission("koukeneko.admin");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        UUID playerId = player.getUniqueId();
        if (!this.isOurMenu(playerId, event.getInventory())) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getSlot();
        if (slot < 0) {
            return;
        }
        Inventory openMenu = this.openMenus.get(playerId);
        if (this.isRemoveButtonClick(slot, openMenu, event.getCurrentItem())) {
            this.handleRemoveButtonClick(player);
            return;
        }
        this.handleTagSelection(player, playerId, slot);
    }

    private boolean isOurMenu(UUID playerId, Inventory clickedInventory) {
        if (!this.openMenus.containsKey(playerId)) {
            return false;
        }
        Inventory openMenu = this.openMenus.get(playerId);
        return clickedInventory == openMenu;
    }

    private boolean isRemoveButtonClick(int slot, Inventory menu, ItemStack clickedItem) {
        return slot == menu.getSize() - 1 && clickedItem != null && clickedItem.getType() == Material.BARRIER;
    }

    private void handleRemoveButtonClick(Player player) {
        this.tagManager.removeActiveTag(player);
        this.plugin.getMessageManager().sendConfigMessage((CommandSender)player, "menu.tag_removed");
        player.closeInventory();
    }

    private void handleTagSelection(Player player, UUID playerId, int slot) {
        List<Tag> tags = this.menuTags.get(playerId);
        if (slot >= tags.size()) {
            return;
        }
        Tag selectedTag = tags.get(slot);
        if (this.tagManager.setActiveTag(player, selectedTag)) {
            this.sendTagSetSuccessMessage(player, selectedTag);
        } else {
            this.plugin.getMessageManager().sendConfigMessage((CommandSender)player, "menu.tag_set_failed");
        }
        player.closeInventory();
    }

    private void sendTagSetSuccessMessage(Player player, Tag selectedTag) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("display", selectedTag.getDisplay());
        this.plugin.getMessageManager().sendConfigMessage((CommandSender)player, "menu.tag_set", placeholders);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        this.cleanupPlayerMenu(player.getUniqueId());
    }

    private void cleanupPlayerMenu(UUID playerId) {
        this.openMenus.remove(playerId);
        this.menuTags.remove(playerId);
    }
}

