/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.commands;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import dev.doeshing.koukeNekoNametag.core.tag.TagManager;
import dev.doeshing.koukeNekoNametag.core.tag.TagMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TagCommand
implements CommandExecutor,
TabCompleter {
    private final KoukeNekoNametag plugin;
    private final TagManager tagManager;
    private final TagMenu tagMenu;

    public TagCommand(KoukeNekoNametag plugin, TagManager tagManager, TagMenu tagMenu) {
        this.plugin = plugin;
        this.tagManager = tagManager;
        this.tagMenu = tagMenu;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                this.plugin.getMessageManager().sendConfigMessage(sender, "error.player_only");
                return true;
            }
            Player player = (Player)sender;
            this.tagMenu.openMenu(player);
            return true;
        }
        if (!sender.hasPermission("koukeneko.admin")) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "error.no_permission");
            return true;
        }
        if (args[0].equalsIgnoreCase("create")) {
            return this.handleCreateCommand(sender, args);
        }
        if (args[0].equalsIgnoreCase("remove")) {
            return this.handleRemoveTagCommand(sender, args);
        }
        Player targetPlayer = Bukkit.getPlayer((String)args[0]);
        if (targetPlayer == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", args[0]);
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.player_not_found", placeholders);
            return true;
        }
        if (args.length < 3) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.help");
            return true;
        }
        String action = args[1].toLowerCase();
        String tagId = args[2];
        Tag tag = this.tagManager.getTag(tagId);
        if (tag == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("tag", tagId);
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_not_found", placeholders);
            return true;
        }
        switch (action) {
            case "add": {
                if (this.tagManager.giveTagPermission(targetPlayer, tag)) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("player", targetPlayer.getName());
                    placeholders.put("display", tag.getDisplay());
                    this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_added", placeholders);
                    HashMap<String, String> playerPlaceholders = new HashMap<String, String>();
                    playerPlaceholders.put("display", tag.getDisplay());
                    this.plugin.getMessageManager().sendConfigMessage((CommandSender)targetPlayer, "tag.you_got_tag", playerPlaceholders);
                    break;
                }
                this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_add_failed");
                break;
            }
            case "remove": {
                if (this.tagManager.removeTagPermission(targetPlayer, tag)) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("player", targetPlayer.getName());
                    placeholders.put("display", tag.getDisplay());
                    this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_removed", placeholders);
                    HashMap<String, String> playerPlaceholders = new HashMap<String, String>();
                    playerPlaceholders.put("display", tag.getDisplay());
                    this.plugin.getMessageManager().sendConfigMessage((CommandSender)targetPlayer, "tag.your_tag_removed", playerPlaceholders);
                    break;
                }
                this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_remove_failed");
                break;
            }
            default: {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("action", action);
                this.plugin.getMessageManager().sendConfigMessage(sender, "tag.unknown_action", placeholders);
                this.plugin.getMessageManager().sendConfigMessage(sender, "tag.help");
            }
        }
        return true;
    }

    private boolean handleCreateCommand(CommandSender sender, String[] args) {
        if (args.length < 3) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.create_usage");
            return true;
        }
        String tagId = args[1];
        String display = args[2];
        if (this.tagManager.getTag(tagId) != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("tag", tagId);
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_exists", placeholders);
            return true;
        }
        Tag tag = this.tagManager.createTag(tagId, display);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("display", tag.getDisplay());
        placeholders.put("id", tag.getId());
        this.plugin.getMessageManager().sendConfigMessage(sender, "tag.created", placeholders);
        return true;
    }

    private boolean handleRemoveTagCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.remove_usage");
            return true;
        }
        String tagId = args[1];
        Tag tag = this.tagManager.getTag(tagId);
        if (tag == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("tag", tagId);
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.tag_not_exists", placeholders);
            return true;
        }
        int affectedPlayers = 0;
        for (Object player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(tag.getPermission())) continue;
            this.tagManager.removeTagPermission((Player)player, tag);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("display", tag.getDisplay());
            this.plugin.getMessageManager().sendConfigMessage((CommandSender)player, "tag.tag_deleted_notice", placeholders);
            ++affectedPlayers;
        }
        List commands = this.plugin.getConfig().getStringList("command.remove_permission_all");
        for (String cmd : commands) {
            cmd = cmd.replace("{tag}", tag.getPermission()).replace("{display}", tag.getDisplay());
            this.plugin.getLogger().info("\u57f7\u884c\u79fb\u9664\u6240\u6709\u73a9\u5bb6\u6a19\u7c64\u6b0a\u9650\u6307\u4ee4: " + cmd);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
        if (this.tagManager.deleteTag(tagId)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("display", tag.getDisplay());
            placeholders.put("id", tagId);
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.deleted", placeholders);
            if (affectedPlayers > 0) {
                HashMap<String, String> countPlaceholders = new HashMap<String, String>();
                countPlaceholders.put("count", String.valueOf(affectedPlayers));
                this.plugin.getMessageManager().sendConfigMessage(sender, "tag.affected_players", countPlaceholders);
            }
        } else {
            this.plugin.getMessageManager().sendConfigMessage(sender, "tag.delete_failed");
        }
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        this.tagManager.reload();
        this.plugin.getMessageManager().sendConfigMessage(sender, "reload.tag_system_reloaded");
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (!sender.hasPermission("koukeneko.admin")) {
            return completions;
        }
        if (args.length == 1) {
            if ("create".startsWith(args[0].toLowerCase())) {
                completions.add("create");
            }
            if ("remove".startsWith(args[0].toLowerCase())) {
                completions.add("remove");
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(player.getName());
            }
            return completions;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("create")) {
                return completions;
            }
            if (args[0].equalsIgnoreCase("remove")) {
                for (Tag tag : this.tagManager.getAllTags()) {
                    if (!tag.getId().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                    completions.add(tag.getId());
                }
                return completions;
            }
            List<String> actions = List.of("add", "remove");
            for (String action : actions) {
                if (!action.startsWith(args[1].toLowerCase())) continue;
                completions.add(action);
            }
            return completions;
        }
        if (args.length == 3) {
            if (!args[0].equalsIgnoreCase("create") && (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove"))) {
                for (Tag tag : this.tagManager.getAllTags()) {
                    if (!tag.getId().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    completions.add(tag.getId());
                }
            }
            return completions;
        }
        return completions;
    }
}

