/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class CommandSystem {
    private final KoukeNekoNametag plugin;

    public CommandSystem(KoukeNekoNametag plugin) {
        this.plugin = plugin;
    }

    public void registerCommand(String commandName, CommandExecutor executor, String commandPermission, String commandDescription, String commandUsage, String ... commandAliases) {
        try {
            Field commandMapField = this.plugin.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(this.plugin.getServer());
            Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructor.setAccessible(true);
            PluginCommand pluginCommand = (PluginCommand)constructor.newInstance(new Object[]{commandName, this.plugin});
            pluginCommand.setExecutor(executor);
            if (executor instanceof TabCompleter) {
                pluginCommand.setTabCompleter((TabCompleter)executor);
            }
            if (commandPermission != null && !commandPermission.isEmpty()) {
                pluginCommand.setPermission(commandPermission);
            }
            if (commandDescription != null) {
                pluginCommand.setDescription(commandDescription);
            }
            if (commandUsage != null) {
                pluginCommand.setUsage(commandUsage);
            }
            if (commandAliases != null && commandAliases.length > 0) {
                pluginCommand.setAliases(Arrays.asList(commandAliases));
            }
            commandMap.register(this.plugin.getName(), (Command)pluginCommand);
            this.plugin.getLogger().info("\u5df2\u8a3b\u518a\u6307\u4ee4: " + commandName);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u8a3b\u518a\u6307\u4ee4 " + commandName + " \u6642\u767c\u751f\u932f\u8aa4:");
            e.printStackTrace();
        }
    }
}

