/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageManager {
    private final KoukeNekoNametag plugin;
    private String prefix;

    public MessageManager(KoukeNekoNametag plugin) {
        this.plugin = plugin;
        this.loadPrefix();
    }

    public void loadPrefix() {
        this.prefix = this.plugin.getConfig().getString("prefix", "&7[&b&l\ud83d\udd79\ufe0f&7]&f");
    }

    public Component format(String text) {
        return LegacyComponentSerializer.legacyAmpersand().deserialize(text);
    }

    public void sendMessage(CommandSender receiver, String message) {
        receiver.sendMessage(this.format(this.prefix + " " + message));
    }

    public void broadcastMessage(String message) {
        Bukkit.broadcast((Component)this.format(this.prefix + " " + message));
    }

    public void broadcastMessage(String message, String permission) {
        Component component = this.format(this.prefix + " " + message);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            player.sendMessage(component);
        }
        Bukkit.getConsoleSender().sendMessage(component);
    }

    public String getMessage(String path) {
        return this.plugin.getLanguageManager().getMessage(path);
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        return this.plugin.getLanguageManager().getMessage(path, placeholders);
    }

    public void sendConfigMessage(CommandSender receiver, String path) {
        this.sendMessage(receiver, this.getMessage(path));
    }

    public void sendConfigMessage(CommandSender receiver, String path, Map<String, String> placeholders) {
        this.sendMessage(receiver, this.getMessage(path, placeholders));
    }
}

