/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core.lang;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final KoukeNekoNametag plugin;
    private FileConfiguration langConfig;
    private String language;
    private File langFile;

    public LanguageManager(KoukeNekoNametag plugin) {
        this.plugin = plugin;
        this.language = plugin.getConfig().getString("language", "zh_TW");
        this.loadLanguage();
    }

    private void loadLanguage() {
        this.langFile = new File(this.plugin.getDataFolder(), "lang_" + this.language + ".yml");
        if (!this.langFile.exists()) {
            try {
                InputStream defaultLangStream = this.plugin.getResource("lang_" + this.language + ".yml");
                if (defaultLangStream != null) {
                    this.plugin.saveResource("lang_" + this.language + ".yml", false);
                } else {
                    this.plugin.getLogger().warning("\u627e\u4e0d\u5230\u8a9e\u8a00\u6a94: " + this.language + "\uff0c\u4f7f\u7528\u9ed8\u8a8d\u8a9e\u8a00");
                    this.language = "zh_TW";
                    this.langFile = new File(this.plugin.getDataFolder(), "lang_" + this.language + ".yml");
                    this.plugin.saveResource("lang_" + this.language + ".yml", false);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("\u7121\u6cd5\u5132\u5b58\u8a9e\u8a00\u6a94: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)this.langFile);
        this.checkForMissingMessages();
    }

    private void checkForMissingMessages() {
        InputStream defaultLangStream = this.plugin.getResource("lang_" + this.language + ".yml");
        if (defaultLangStream == null) {
            return;
        }
        YamlConfiguration defaultLangConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultLangStream, StandardCharsets.UTF_8));
        boolean updated = false;
        for (String key : defaultLangConfig.getKeys(true)) {
            if (defaultLangConfig.isConfigurationSection(key) || this.langConfig.contains(key)) continue;
            this.langConfig.set(key, defaultLangConfig.get(key));
            updated = true;
        }
        if (updated) {
            try {
                this.langConfig.save(this.langFile);
                this.plugin.getLogger().info("\u8a9e\u8a00\u6a94\u5df2\u66f4\u65b0: " + this.langFile.getName());
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("\u7121\u6cd5\u5132\u5b58\u66f4\u65b0\u7684\u8a9e\u8a00\u6a94: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        String message = this.langConfig.getString(path);
        if (message == null) {
            String fallbackMessage = this.langConfig.getString("error.message_not_found", "Message not found: {path}");
            return fallbackMessage.replace("{path}", path);
        }
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return message;
    }

    public String getMessage(String path) {
        return this.getMessage(path, null);
    }

    public static Map<String, String> placeholder(String key, String value) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put(key, value);
        return placeholders;
    }

    public static Map<String, String> placeholders(String[] keys, String[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("\u4f54\u4f4d\u7b26\u9375\u548c\u503c\u7684\u6578\u91cf\u5fc5\u9808\u76f8\u540c");
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        for (int i = 0; i < keys.length; ++i) {
            placeholders.put(keys[i], values[i]);
        }
        return placeholders;
    }

    public void reload() {
        this.language = this.plugin.getConfig().getString("language", "zh_TW");
        this.loadLanguage();
    }
}

