/*
 * Decompiled with CFR 0.152.
 */
package dev.doeshing.koukeNekoNametag.core.tag;

import dev.doeshing.koukeNekoNametag.KoukeNekoNametag;
import dev.doeshing.koukeNekoNametag.core.tag.Tag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class TagManager {
    private final KoukeNekoNametag plugin;
    private final Map<String, Tag> tags;
    private File tagsFile;
    private FileConfiguration tagsConfig;

    public TagManager(KoukeNekoNametag plugin) {
        this.plugin = plugin;
        this.tags = new HashMap<String, Tag>();
        this.loadTagsConfig();
    }

    public void loadTagsConfig() {
        this.tagsFile = new File(this.plugin.getDataFolder(), "tags.yml");
        if (!this.tagsFile.exists()) {
            this.plugin.saveResource("tags.yml", false);
        }
        this.tagsConfig = YamlConfiguration.loadConfiguration((File)this.tagsFile);
        this.loadTags();
    }

    private void loadTags() {
        this.tags.clear();
        ConfigurationSection tagsSection = this.tagsConfig.getConfigurationSection("tags");
        if (tagsSection == null) {
            this.plugin.getLogger().warning("No tags section found in tags.yml!");
            return;
        }
        for (String tagId : tagsSection.getKeys(false)) {
            String display = tagsSection.getString(tagId + ".display", "&7[" + tagId + "]&f");
            Tag tag = new Tag(tagId, display);
            this.tags.put(tagId, tag);
            this.plugin.getLogger().info("Loaded tag: " + tagId + " with display: " + display);
        }
    }

    public void saveTags() {
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            String tagId = entry.getKey();
            Tag tag = entry.getValue();
            this.tagsConfig.set("tags." + tagId + ".display", (Object)tag.getDisplay());
        }
        try {
            this.tagsConfig.save(this.tagsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save tags.yml: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void reload() {
        this.loadTagsConfig();
    }

    public Collection<Tag> getAllTags() {
        return this.tags.values();
    }

    public Tag getTag(String id) {
        return this.tags.get(id);
    }

    public Tag createTag(String id, String display) {
        Tag tag = new Tag(id, display);
        this.tags.put(id, tag);
        this.tagsConfig.set("tags." + id + ".display", (Object)display);
        try {
            this.tagsConfig.save(this.tagsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save tags.yml: " + e.getMessage());
            e.printStackTrace();
        }
        return tag;
    }

    public boolean deleteTag(String id) {
        if (!this.tags.containsKey(id)) {
            return false;
        }
        this.tags.remove(id);
        this.tagsConfig.set("tags." + id, null);
        try {
            this.tagsConfig.save(this.tagsFile);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save tags.yml: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public List<Tag> getAvailableTags(Player player) {
        ArrayList<Tag> availableTags = new ArrayList<Tag>();
        for (Tag tag : this.tags.values()) {
            if (!player.hasPermission(tag.getPermission())) continue;
            availableTags.add(tag);
        }
        return availableTags;
    }

    public boolean setActiveTag(Player player, Tag tag) {
        if (tag == null) {
            return false;
        }
        if (!player.hasPermission(tag.getPermission())) {
            return false;
        }
        this.removeActiveTag(player);
        List commands = this.plugin.getConfig().getStringList("command.settag");
        for (String cmd : commands) {
            cmd = cmd.replace("{player}", player.getName()).replace("{tag}", tag.getDisplay());
            this.plugin.getLogger().info("\u57f7\u884c\u6307\u4ee4: " + cmd);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
        return true;
    }

    public boolean removeActiveTag(Player player) {
        List commands = this.plugin.getConfig().getStringList("command.remove");
        for (String cmd : commands) {
            cmd = cmd.replace("{player}", player.getName());
            this.plugin.getLogger().info("\u57f7\u884c\u6307\u4ee4: " + cmd);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
        return true;
    }

    public boolean giveTagPermission(Player player, Tag tag) {
        if (tag == null) {
            return false;
        }
        List commands = this.plugin.getConfig().getStringList("command.add_permission");
        for (String cmd : commands) {
            cmd = cmd.replace("{player}", player.getName()).replace("{tag}", tag.getPermission());
            this.plugin.getLogger().info("\u57f7\u884c\u6307\u4ee4: " + cmd);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
        return true;
    }

    public boolean removeTagPermission(Player player, Tag tag) {
        if (tag == null) {
            return false;
        }
        List commands = this.plugin.getConfig().getStringList("command.remove_permission");
        for (String cmd : commands) {
            cmd = cmd.replace("{player}", player.getName()).replace("{tag}", tag.getPermission());
            this.plugin.getLogger().info("\u57f7\u884c\u6307\u4ee4: " + cmd);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
        }
        return true;
    }
}

