/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.ui;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8658;
import net.minecraft.class_8690;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Color;
import snownee.jade.api.ui.ColorPalette;
import snownee.jade.api.ui.Direction2D;
import snownee.jade.impl.theme.ThemeCodecs;
import snownee.jade.impl.ui.StyledElement;
import snownee.jade.overlay.DisplayHelper;

public abstract class BoxStyle
implements Cloneable {
    private static final int[] DEFAULT_PADDING = new int[]{4, 4, 4, 4};
    public static final Codec<GradientBorder> GRADIENT_BORDER_CODEC = RecordCodecBuilder.create(i -> i.group((App)ThemeCodecs.floatArrayCodec(4, (Codec<Float>)Codec.FLOAT).optionalFieldOf("boxProgressOffset").forGetter($ -> Optional.ofNullable($.boxProgressOffset)), (App)ColorPalette.CODEC.optionalFieldOf("boxProgressColors", (Object)ColorPalette.DEFAULT).forGetter($ -> $.boxProgressColors), (App)ThemeCodecs.intArrayCodec(4, (Codec<Integer>)Codec.INT).optionalFieldOf("padding").forGetter($ -> Optional.ofNullable($.padding)), (App)Color.CODEC.optionalFieldOf("backgroundColor", (Object)-1).forGetter($ -> $.bgColor), (App)ThemeCodecs.intArrayCodec(4, Color.CODEC).fieldOf("borderColor").forGetter($ -> $.borderColor), (App)Codec.FLOAT.optionalFieldOf("borderWidth", (Object)Float.valueOf(1.0f)).forGetter($ -> Float.valueOf($.borderWidth)), (App)Codec.BOOL.optionalFieldOf("roundCorner").forGetter($ -> Optional.ofNullable($.roundCorner))).apply((Applicative)i, GradientBorder::new));
    public static final Codec<SpriteBase> SPRITE_BASE_CODEC = RecordCodecBuilder.create(i -> i.group((App)ThemeCodecs.floatArrayCodec(4, (Codec<Float>)Codec.FLOAT).optionalFieldOf("boxProgressOffset").forGetter($ -> Optional.ofNullable($.boxProgressOffset)), (App)ColorPalette.CODEC.optionalFieldOf("boxProgressColors", (Object)ColorPalette.DEFAULT).forGetter($ -> $.boxProgressColors), (App)ThemeCodecs.intArrayCodec(4, (Codec<Integer>)Codec.INT).optionalFieldOf("padding").forGetter($ -> Optional.ofNullable($.padding)), (App)class_2960.field_25139.fieldOf("sprite").forGetter($ -> $.sprite), (App)class_2960.field_25139.optionalFieldOf("withIconSprite").forGetter($ -> Optional.ofNullable($.withIconSprite))).apply((Applicative)i, SpriteBase::new));
    public static final Codec<BoxStyle> CODEC = Codec.either(GRADIENT_BORDER_CODEC, SPRITE_BASE_CODEC).xmap($ -> (BoxStyle)$.map(Function.identity(), Function.identity()), $ -> $ instanceof GradientBorder ? Either.left((Object)((GradientBorder)$)) : Either.right((Object)((SpriteBase)$)));
    public final float[] boxProgressOffset;
    public final int[] padding;
    public ColorPalette boxProgressColors;

    public BoxStyle(Optional<float[]> boxProgressOffset, ColorPalette boxProgressColors, Optional<int[]> padding) {
        this.boxProgressOffset = boxProgressOffset.orElse(null);
        this.boxProgressColors = boxProgressColors;
        this.padding = padding.orElseGet(() -> (int[])DEFAULT_PADDING.clone());
    }

    public static BoxStyle getNestedBox() {
        return IThemeHelper.get().theme().nestedBoxStyle;
    }

    public static BoxStyle getViewGroup() {
        return IThemeHelper.get().theme().viewGroupStyle;
    }

    public static GradientBorder getTransparent() {
        return GradientBorder.TRANSPARENT;
    }

    public static BoxStyle getSprite(class_2960 sprite, @Nullable int[] padding) {
        return new SpriteBase(Optional.empty(), ColorPalette.DEFAULT, Optional.ofNullable(padding), sprite, Optional.empty());
    }

    public abstract void render(class_332 var1, StyledElement var2, float var3, float var4, float var5, float var6, float var7);

    public abstract float borderWidth();

    public float boxProgressOffset(Direction2D dir) {
        return this.boxProgressOffset == null ? 0.0f : this.boxProgressOffset[dir.ordinal()];
    }

    public int padding(Direction2D dir) {
        return ((int[])MoreObjects.firstNonNull((Object)this.padding, (Object)DEFAULT_PADDING))[dir.ordinal()];
    }

    public abstract BoxStyle clone();

    public boolean hasRoundCorner() {
        return false;
    }

    public static class GradientBorder
    extends BoxStyle {
        public static final GradientBorder TRANSPARENT = new GradientBorder(Optional.empty(), ColorPalette.DEFAULT, Optional.empty(), -1, new int[]{-1, -1, -1, -1}, 0.0f, Optional.of(false));
        public static final GradientBorder DEFAULT_NESTED_BOX = new GradientBorder(Optional.empty(), ColorPalette.DEFAULT, Optional.empty(), -1, new int[]{-8355712, -8355712, -8355712, -8355712}, 1.0f, Optional.empty());
        public static final GradientBorder DEFAULT_VIEW_GROUP = new GradientBorder(Optional.empty(), ColorPalette.DEFAULT, Optional.of(new int[]{2, 2, 2, 2}), 0x44444444, new int[]{0x44444444, 0x44444444, 0x44444444, 0x44444444}, 0.75f, Optional.empty());
        public int bgColor;
        public int[] borderColor;
        public float borderWidth;
        @Nullable
        public Boolean roundCorner;

        private GradientBorder(Optional<float[]> boxProgressOffset, ColorPalette boxProgressColors, Optional<int[]> padding, int bgColor, int[] borderColor, float borderWidth, Optional<Boolean> roundCorner) {
            super(boxProgressOffset, boxProgressColors, padding);
            this.bgColor = bgColor;
            this.borderColor = borderColor;
            this.borderWidth = borderWidth;
            this.roundCorner = roundCorner.orElse(null);
        }

        @Override
        public float borderWidth() {
            return this.borderWidth;
        }

        @Override
        public void render(class_332 guiGraphics, StyledElement element, float x, float y, float w, float h, float alpha) {
            boolean roundCorner = this.hasRoundCorner();
            if (this.bgColor != -1) {
                int bg = IWailaConfig.IConfigOverlay.applyAlpha(this.bgColor, alpha);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + this.borderWidth, y + this.borderWidth, w - this.borderWidth - this.borderWidth, h - this.borderWidth - this.borderWidth, bg, bg);
                if (roundCorner) {
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y - 1.0f, w, 1.0f, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + h, w, 1.0f, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x - 1.0f, y, 1.0f, h, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + w, y, 1.0f, h, bg, bg);
                }
            }
            if (this.borderWidth > 0.0f) {
                int[] borderColors = new int[4];
                for (int i = 0; i < 4; ++i) {
                    if (this.borderColor[i] == -1) continue;
                    borderColors[i] = IWailaConfig.IConfigOverlay.applyAlpha(this.borderColor[i], alpha);
                }
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + this.borderWidth, this.borderWidth, h - this.borderWidth - this.borderWidth, borderColors[0], borderColors[3]);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + w - this.borderWidth, y + this.borderWidth, this.borderWidth, h - this.borderWidth - this.borderWidth, borderColors[1], borderColors[2]);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y, w, this.borderWidth, borderColors[0], borderColors[1]);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + h - this.borderWidth, w, this.borderWidth, borderColors[3], borderColors[2]);
            }
        }

        @Override
        public GradientBorder clone() {
            return new GradientBorder(ThemeCodecs.nullableClone(this.boxProgressOffset), this.boxProgressColors, ThemeCodecs.nullableClone(this.padding), this.bgColor, this.borderColor, this.borderWidth, Optional.ofNullable(this.roundCorner));
        }

        @Override
        public boolean hasRoundCorner() {
            return this.roundCorner == null ? !IWailaConfig.get().getOverlay().getSquare() : this.roundCorner;
        }
    }

    public static class SpriteBase
    extends BoxStyle {
        public class_2960 sprite;
        @Nullable
        public class_2960 withIconSprite;

        public SpriteBase(Optional<float[]> boxProgressOffset, ColorPalette boxProgressColors, Optional<int[]> padding, class_2960 sprite, Optional<class_2960> withIconSprite) {
            super(boxProgressOffset, boxProgressColors, padding);
            this.sprite = sprite;
            this.withIconSprite = withIconSprite.orElse(null);
        }

        public static void blitSprite(class_332 guiGraphics, class_2960 resourceLocation, int i, int j, int k, int l, int m) {
            class_1058 textureAtlasSprite;
            class_8658 sprites = class_310.method_1551().method_52699();
            class_8690 guiSpriteScaling = sprites.method_52714(textureAtlasSprite = sprites.method_18667(resourceLocation));
            if (guiSpriteScaling instanceof class_8690.class_8693) {
                guiGraphics.method_52707(resourceLocation, i, j, k, l, m);
            } else if (guiSpriteScaling instanceof class_8690.class_8694) {
                class_8690.class_8694 tile = (class_8690.class_8694)guiSpriteScaling;
                guiGraphics.method_52712(textureAtlasSprite, i, j, k, l, m, 0, 0, tile.comp_1644(), tile.comp_1645(), tile.comp_1644(), tile.comp_1645());
            } else if (guiSpriteScaling instanceof class_8690.class_8691) {
                class_8690.class_8691 nineSlice = (class_8690.class_8691)guiSpriteScaling;
                SpriteBase.blitNineSlicedSprite(guiGraphics, textureAtlasSprite, nineSlice, i, j, k, l, m);
            }
        }

        public static void blitNineSlicedSprite(class_332 guiGraphics, class_1058 textureAtlasSprite, class_8690.class_8691 nineSlice, int i, int j, int k, int l, int m) {
            class_8690.class_8691.class_8692 border = nineSlice.comp_1639();
            int n = Math.min(border.comp_1640(), l / 2);
            int o = Math.min(border.comp_1642(), l / 2);
            int p = Math.min(border.comp_1641(), m / 2);
            int q = Math.min(border.comp_1643(), m / 2);
            if (l == nineSlice.comp_1637() && m == nineSlice.comp_1638()) {
                guiGraphics.method_52711(textureAtlasSprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, 0, i, j, k, l, m);
                return;
            }
            if (m == nineSlice.comp_1638()) {
                guiGraphics.method_52711(textureAtlasSprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, 0, i, j, k, n, m);
                guiGraphics.method_52712(textureAtlasSprite, i + n, j, k, l - o - n, m, n, 0, nineSlice.comp_1637() - o - n, nineSlice.comp_1638(), nineSlice.comp_1637(), nineSlice.comp_1638());
                guiGraphics.method_52711(textureAtlasSprite, nineSlice.comp_1637(), nineSlice.comp_1638(), nineSlice.comp_1637() - o, 0, i + l - o, j, k, o, m);
                return;
            }
            if (l == nineSlice.comp_1637()) {
                guiGraphics.method_52711(textureAtlasSprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, 0, i, j, k, l, p);
                guiGraphics.method_52712(textureAtlasSprite, i, j + p, k, l, m - q - p, 0, p, nineSlice.comp_1637(), nineSlice.comp_1638() - q - p, nineSlice.comp_1637(), nineSlice.comp_1638());
                guiGraphics.method_52711(textureAtlasSprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, nineSlice.comp_1638() - q, i, j + m - q, k, l, q);
                return;
            }
            guiGraphics.method_52711(textureAtlasSprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, 0, i, j, k, n, p);
            guiGraphics.method_52712(textureAtlasSprite, i + n, j, k, l - o - n, p, n, 0, nineSlice.comp_1637() - o - n, p, nineSlice.comp_1637(), nineSlice.comp_1638());
            guiGraphics.method_52711(textureAtlasSprite, nineSlice.comp_1637(), nineSlice.comp_1638(), nineSlice.comp_1637() - o, 0, i + l - o, j, k, o, p);
            guiGraphics.method_52711(textureAtlasSprite, nineSlice.comp_1637(), nineSlice.comp_1638(), 0, nineSlice.comp_1638() - q, i, j + m - q, k, n, q);
            guiGraphics.method_52712(textureAtlasSprite, i + n, j + m - q, k, l - o - n, q, n, nineSlice.comp_1638() - q, nineSlice.comp_1637() - o - n, q, nineSlice.comp_1637(), nineSlice.comp_1638());
            guiGraphics.method_52711(textureAtlasSprite, nineSlice.comp_1637(), nineSlice.comp_1638(), nineSlice.comp_1637() - o, nineSlice.comp_1638() - q, i + l - o, j + m - q, k, o, q);
            guiGraphics.method_52712(textureAtlasSprite, i, j + p, k, n, m - q - p, 0, p, n, nineSlice.comp_1638() - q - p, nineSlice.comp_1637(), nineSlice.comp_1638());
            guiGraphics.method_52712(textureAtlasSprite, i + n, j + p, k, l - o - n, m - q - p, n, p, nineSlice.comp_1637() - o - n, nineSlice.comp_1638() - q - p, nineSlice.comp_1637(), nineSlice.comp_1638());
            guiGraphics.method_52712(textureAtlasSprite, i + l - o, j + p, k, o, m - q - p, nineSlice.comp_1637() - o, p, o, nineSlice.comp_1638() - q - p, nineSlice.comp_1637(), nineSlice.comp_1638());
        }

        @Override
        public void render(class_332 guiGraphics, StyledElement element, float x, float y, float w, float h, float alpha) {
            class_2960 texture = this.sprite;
            if (this.withIconSprite != null && element.getIcon() != null) {
                texture = this.withIconSprite;
            }
            RenderSystem.enableBlend();
            guiGraphics.method_51422(1.0f, 1.0f, 1.0f, alpha);
            SpriteBase.blitSprite(guiGraphics, texture, Math.round(x), Math.round(y), 0, Math.round(w), Math.round(h));
            guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public float borderWidth() {
            return 0.0f;
        }

        @Override
        public SpriteBase clone() {
            return new SpriteBase(ThemeCodecs.nullableClone(this.boxProgressOffset), this.boxProgressColors, ThemeCodecs.nullableClone(this.padding), this.sprite, Optional.ofNullable(this.withIconSprite));
        }
    }
}

