/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import snownee.jade.Jade;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class EntityAccessorImpl
extends AccessorImpl<class_3966>
implements EntityAccessor {
    private final java.util.function.Supplier<class_1297> entity;

    public EntityAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, builder.hit, builder.connected, builder.showDetails);
        this.entity = builder.entity;
    }

    public static void handleRequest(SyncData data, class_3222 player, Consumer<Runnable> executor, Consumer<class_2487> responseSender) {
        executor.accept(() -> {
            EntityAccessor accessor = data.unpack(player);
            if (accessor == null) {
                return;
            }
            class_1297 entity = accessor.getEntity();
            if (entity == null || player.method_5858(entity) > (double)Jade.MAX_DISTANCE_SQR) {
                return;
            }
            List<IServerDataProvider<EntityAccessor>> providers = WailaCommonRegistration.instance().getEntityNBTProviders(entity);
            if (providers.isEmpty()) {
                return;
            }
            class_2487 tag = accessor.getServerData();
            for (IServerDataProvider<EntityAccessor> provider : providers) {
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Exception e) {
                    WailaExceptionHandler.handleErr(e, provider, null);
                }
            }
            tag.method_10569("WailaEntityID", entity.method_5628());
            responseSender.accept(tag);
        });
    }

    @Override
    @Deprecated
    public void toNetwork(class_2540 buf) {
        buf.method_52964(this.showDetails());
        class_1297 entity = this.getEntity();
        buf.method_10804(entity.method_5628());
        if (CommonProxy.isMultipartEntity(entity)) {
            buf.method_10804(CommonProxy.getPartEntityIndex(entity));
        } else {
            buf.method_10804(-1);
        }
        class_243 hitVec = ((class_3966)this.getHitResult()).method_17784();
        buf.method_52941((float)hitVec.field_1352);
        buf.method_52941((float)hitVec.field_1351);
        buf.method_52941((float)hitVec.field_1350);
    }

    @Override
    public class_1297 getEntity() {
        return CommonProxy.wrapPartEntityParent(this.getRawEntity());
    }

    @Override
    public class_1297 getRawEntity() {
        return this.entity.get();
    }

    @Override
    public class_1799 getPickedResult() {
        return CommonProxy.getEntityPickedResult(this.entity.get(), this.getPlayer(), (class_3966)this.getHitResult());
    }

    @Override
    public Object getTarget() {
        return this.getEntity();
    }

    @Override
    public boolean verifyData(class_2487 data) {
        if (!this.verify) {
            return true;
        }
        if (!data.method_10545("WailaEntityID")) {
            return false;
        }
        return data.method_10550("WailaEntityID") == this.getEntity().method_5628();
    }

    public static class Builder
    implements EntityAccessor.Builder {
        public boolean showDetails;
        private class_1937 level;
        private class_1657 player;
        private class_2487 serverData;
        private boolean connected;
        private java.util.function.Supplier<class_3966> hit;
        private java.util.function.Supplier<class_1297> entity;
        private boolean verify;

        @Override
        public Builder level(class_1937 level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(class_1657 player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(class_2487 serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(java.util.function.Supplier<class_3966> hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder entity(java.util.function.Supplier<class_1297> entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder from(EntityAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = accessor::getHitResult;
            this.entity = accessor::getEntity;
            return this;
        }

        @Override
        public EntityAccessor.Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public EntityAccessor build() {
            EntityAccessorImpl accessor = new EntityAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }

    public record SyncData(boolean showDetails, int id, int partIndex, class_243 hitVec) {
        public SyncData(EntityAccessor accessor) {
            this(accessor.showDetails(), accessor.getEntity().method_5628(), CommonProxy.getPartEntityIndex(accessor.getRawEntity()), ((class_3966)accessor.getHitResult()).method_17784());
        }

        public SyncData(class_2540 buffer) {
            this(buffer.readBoolean(), buffer.method_10816(), buffer.method_10816(), new class_243((double)buffer.readFloat(), (double)buffer.readFloat(), (double)buffer.readFloat()));
        }

        public void write(class_2540 buffer) {
            buffer.method_52964(this.showDetails);
            buffer.method_10804(this.id);
            buffer.method_10804(this.partIndex);
            buffer.method_52941((float)this.hitVec.field_1352);
            buffer.method_52941((float)this.hitVec.field_1351);
            buffer.method_52941((float)this.hitVec.field_1350);
        }

        public EntityAccessor unpack(class_3222 player) {
            Supplier entity = Suppliers.memoize(() -> CommonProxy.getPartEntity(player.method_37908().method_8469(this.id), this.partIndex));
            return ((Builder)((Builder)new Builder().level(player.method_37908()).player((class_1657)player).showDetails(this.showDetails).entity((java.util.function.Supplier)entity)).hit((java.util.function.Supplier)Suppliers.memoize(() -> this.lambda$unpack$1((java.util.function.Supplier)entity)))).build();
        }

        private /* synthetic */ class_3966 lambda$unpack$1(java.util.function.Supplier entity) {
            return new class_3966((class_1297)entity.get(), this.hitVec);
        }
    }
}

