/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Multimap;
import java.util.Comparator;
import snownee.jade.api.IJadeProvider;
import snownee.jade.impl.HierarchyLookup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;

public class DumpGenerator {
    public static String generateInfoDump() {
        StringBuilder builder = new StringBuilder("# Jade Handler Dump");
        WailaClientRegistration client = WailaClientRegistration.instance();
        WailaCommonRegistration common = WailaCommonRegistration.instance();
        builder.append("\n## Block");
        DumpGenerator.createSection(builder, "Icon Providers", client.blockIconProviders);
        DumpGenerator.createSection(builder, "Component Providers", client.blockComponentProviders);
        DumpGenerator.createSection(builder, "Data Providers", common.blockDataProviders);
        builder.append("\n## Entity");
        DumpGenerator.createSection(builder, "Icon Providers", client.entityIconProviders);
        DumpGenerator.createSection(builder, "Component Providers", client.entityComponentProviders);
        DumpGenerator.createSection(builder, "Data Providers", common.entityDataProviders);
        return builder.toString();
    }

    private static void createSection(StringBuilder builder, String subsection, HierarchyLookup<? extends IJadeProvider> lookup) {
        Multimap<Class<?>, ? extends IJadeProvider> multimap = lookup.getObjects();
        if (multimap.isEmpty()) {
            return;
        }
        builder.append("\n### ").append(subsection);
        multimap.asMap().forEach((k, v) -> {
            builder.append("\n\n#### ").append(k.getName());
            v.stream().distinct().sorted(Comparator.comparingInt(WailaCommonRegistration.instance().priorities::byValue)).forEach($ -> builder.append("\n* ").append($.getUid()).append(", ").append(WailaCommonRegistration.instance().priorities.byValue((IJadeProvider)$)).append(", ").append($.getClass().getName()));
        });
        builder.append("\n\n");
    }
}

