/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TElementList;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.menu.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenWrapper;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.client.mixin.TCMInternal;
import java.awt.Point;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import net.minecraft.class_918;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class TScreen
implements TParentElement {
    @Nullable
    protected class_310 client = TCDCommonsClient.MC_CLIENT;
    protected final TElementList children = new TElementList(this);
    @ApiStatus.Internal
    private final TScreenWrapper<?> __wrapper;
    @Nullable
    protected class_2561 title;
    @ApiStatus.Internal
    @Nullable
    TElement __hovered = null;
    @ApiStatus.Internal
    @Nullable
    TElement __dragging = null;
    @ApiStatus.Internal
    @Nullable
    TElement __focused = null;
    @ApiStatus.Internal
    int __draggingButton = -1;
    @ApiStatus.Internal
    final Point __mousePosition = new Point(0, 0);

    public TScreen(class_2561 title) {
        this.title = Objects.requireNonNull(title);
        this.__wrapper = Objects.requireNonNull(this.createScreenWrapper());
    }

    @Virtual
    protected TScreenWrapper<?> createScreenWrapper() {
        return new TScreenWrapper<TScreen>(this);
    }

    public final class_437 getAsScreen() {
        return this.__wrapper;
    }

    @Nullable
    public final class_310 getClient() {
        return this.client;
    }

    public final class_327 getTextRenderer() {
        return this.client.field_1772;
    }

    public final class_918 getItemRenderer() {
        return this.client.method_1480();
    }

    public final class_2561 getTitle() {
        return this.title;
    }

    @Override
    public final boolean isEnabled() {
        return TParentElement.super.isEnabled();
    }

    @Override
    public final boolean getEnabled() {
        return true;
    }

    @Virtual
    public void close() {
        this.__wrapper.Screen_super_close();
    }

    @Virtual
    protected void onOpened() {
    }

    @Virtual
    protected void onClosed() {
    }

    @Virtual
    public boolean shouldPause() {
        return true;
    }

    @Virtual
    public boolean shouldCloseOnEsc() {
        return true;
    }

    @Virtual
    public boolean shouldRenderInGameHud() {
        return true;
    }

    public final boolean isOpen() {
        return TCDCommonsClient.MC_CLIENT.field_1755 == this.__wrapper;
    }

    public final Point getMousePosition() {
        return this.__mousePosition.getLocation();
    }

    @ApiStatus.Internal
    final void setMousePosition(int x, int y) {
        this.__mousePosition.x = x;
        this.__mousePosition.y = y;
    }

    @Override
    @Nullable
    public final TParentElement getParent() {
        return null;
    }

    @Override
    public final TElementList getChildren() {
        return this.children;
    }

    @Override
    public final int getX() {
        return 0;
    }

    @Override
    public final int getY() {
        return 0;
    }

    @Override
    public final int getWidth() {
        return this.__wrapper.field_22789;
    }

    @Override
    public final int getHeight() {
        return this.__wrapper.field_22790;
    }

    @Nullable
    public final TElement getDraggingElement() {
        return this.__dragging;
    }

    @Nullable
    public final TElement getHoveredElement() {
        return this.__hovered;
    }

    @Nullable
    public final TElement getFocusedElement() {
        return this.__focused;
    }

    public final boolean setFocusedElement(TElement child) {
        return this.setFocusedElement(child, false);
    }

    public final boolean setFocusedElement(TElement child, boolean askToFocus) {
        if (child != null && (child.getParentTScreen() != this || askToFocus && !child.isFocusable())) {
            return false;
        }
        this.__focused = child;
        return true;
    }

    protected abstract void init();

    @Virtual
    protected void tick() {
    }

    @Override
    public final float getZIndex() {
        return 0.0f;
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        this.renderBackground(pencil);
        this.renderChildren(pencil);
        if (!(this.getChildren().getLastChild() instanceof TContextMenuPanel)) {
            this.renderTooltip(pencil);
        }
    }

    @Virtual
    public void renderBackground(TDrawContext pencil) {
        if (this.client.field_1687 == null) {
            this.__wrapper.Screen_super_renderBackground(pencil, pencil.mouseX, pencil.mouseY, pencil.deltaTime);
        }
    }

    protected final void renderChildren(TDrawContext pencil) {
        TCMInternal.CURRENT_SCISSORS.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.__renderChildren(pencil, null, 0);
    }

    private final void __renderChildren(TDrawContext pencil, TElement teParent, int iteration) {
        if (iteration > 16) {
            return;
        }
        TParentElement parent = teParent != null ? teParent : this;
        int pX = parent.getX();
        int pY = parent.getY();
        int pXW = pX + parent.getWidth();
        int pYH = pY + parent.getHeight();
        pencil.method_44379(pX, pY, pXW, pYH);
        if (TCMInternal.CURRENT_SCISSORS.width <= 1 || TCMInternal.CURRENT_SCISSORS.height <= 1) {
            pencil.method_44380();
            return;
        }
        parent.forEachChild(child -> {
            if (child.getY() >= TCMInternal.CURRENT_SCISSORS.y + TCMInternal.CURRENT_SCISSORS.height || child.getX() >= TCMInternal.CURRENT_SCISSORS.x + TCMInternal.CURRENT_SCISSORS.width || child.getEndY() <= TCMInternal.CURRENT_SCISSORS.y || child.getEndX() <= TCMInternal.CURRENT_SCISSORS.x) {
                return;
            }
            pencil.method_51448().method_22903();
            pencil.method_51448().method_46416(0.0f, 0.0f, child.getZOffset());
            pencil.pushTShaderColor(1.0f, 1.0f, 1.0f, child.getAlpha());
            pencil.updateContext((TParentElement)child);
            child.render(pencil);
            this.__renderChildren(pencil, (TElement)child, iteration + 1);
            pencil.updateContext((TParentElement)child);
            child.postRender(pencil);
            pencil.updateContext(this);
            pencil.popTShaderColor();
            pencil.method_51448().method_22909();
        }, false);
        pencil.method_44380();
    }

    protected final void renderTooltip(TDrawContext pencil) {
        TElement target;
        TElement tElement = target = this.__focused != null && this.__focused.getTooltip() != null ? this.__focused : this.__hovered;
        if (target != null && target.getTooltip() == null) {
            target = target.findParentTElement(p -> p.getTooltip() != null);
        }
        if (target == null) {
            return;
        }
        class_7919 tt = target.getTooltip();
        class_8000 ttp = target.getTooltipPositioner();
        if (tt != null && ttp != null) {
            this.__wrapper.method_47412(tt, ttp, true);
        }
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        return false;
    }

    protected final boolean inputTabNavigation(boolean reverse) {
        if (this.__focused == null && this.children.size() > 0) {
            this.__focused = reverse ? this.findLastChild(c -> c.isFocusable(), true) : this.findChild(c -> c.isFocusable(), true);
        } else if (this.__focused != null) {
            if (this.__focused.findParent(p -> p == this) == null) {
                this.__focused = null;
                return this.inputTabNavigation(reverse);
            }
            do {
                TElement tElement = this.__focused = reverse ? this.__focused.previous() : this.__focused.next();
            } while (this.__focused != null && !this.__focused.isFocusable());
        } else {
            return false;
        }
        this.__postTabNavigation();
        return true;
    }

    @ApiStatus.Internal
    protected final void __postTabNavigation() {
        TContextMenuPanel cmp;
        if (this.__focused != null && this.__focused.getParent() instanceof TPanelElement) {
            ((TPanelElement)this.__focused.getParent()).scrollToChild(this.__focused);
        }
        if ((cmp = (TContextMenuPanel)this.findChild(c -> c instanceof TContextMenuPanel, false)) != null && cmp.closeIfNotFocused()) {
            this.setFocusedElement(cmp.getTarget(), false);
        }
    }

    @Virtual
    public boolean filesDragged(Collection<Path> files) {
        return false;
    }

    @ApiStatus.Internal
    final void __recalculateHoveredChild(int mouseX, int mouseY) {
        AtomicReference<Object> hovered = new AtomicReference<Object>(null);
        this.forEachChild(child -> {
            if (!child.isHoverable() || !child.isVisible() || hovered.get() != null && child.getZIndex() < ((TElement)hovered.get()).getZIndex() || !this.__isMouseInElementBounds(mouseX, mouseY, (TParentElement)child) || child.findParent(p -> !this.__isMouseInElementBounds(mouseX, mouseY, (TParentElement)p)) != null) {
                return;
            }
            hovered.set(child);
        }, true);
        this.__hovered = hovered.get();
    }

    @ApiStatus.Internal
    final boolean __isMouseInElementBounds(int mX, int mY, TParentElement child) {
        int cX = child.getX();
        int cY = child.getY();
        int cXW = cX + child.getWidth();
        int cYH = cY + child.getHeight();
        return mX >= cX && mX <= cXW && mY >= cY && mY <= cYH;
    }

    public static boolean hasKeyDown(int keyCode) {
        return class_3675.method_15987((long)TCDCommonsClient.MC_CLIENT.method_22683().method_4490(), (int)keyCode);
    }

    public static boolean hasWndDown() {
        return TScreen.hasKeyDown(343) || TScreen.hasKeyDown(347);
    }
}

