/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer;

import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl.TFileExplorerPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.TFileChooserResult;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.TFileChooserScreen;
import io.github.thecsdev.tcdcommons.api.util.enumerations.FileChooserDialogType;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class FEPProxy
implements TFileExplorerPanel.FileExplorerPanelProxy {
    protected final TFileChooserScreen screen;

    protected FEPProxy(TFileChooserScreen screen) {
        this.screen = Objects.requireNonNull(screen);
    }

    @Override
    public final FileChooserDialogType getDialogType() {
        return this.screen.type;
    }

    @Override
    public final Iterable<TFileFilter> getFileFilters() {
        return this.screen.filters;
    }

    @Override
    public final TFileFilter getSelectedFileFilter() {
        return this.screen.currentFileFilter;
    }

    @Override
    public final void setSelectedFileFilter(TFileFilter fileFilter) {
        this.screen.currentFileFilter = fileFilter;
    }

    @Override
    public final Path getCurrentDirectory() {
        return this.screen.currentPath;
    }

    @Override
    public final void setCurrentDirectory(Path directory) {
        this.screen.currentPath = directory;
    }

    @Override
    @Nullable
    public final String getTargetFileExtension() {
        return this.screen.targetExtension;
    }

    @Override
    public final boolean canRestore() {
        return true;
    }

    @Override
    public void onRestore() {
        this.screen.fullScreen = !this.screen.fullScreen;
        this.screen.refresh();
    }

    @Override
    public final boolean canDrag() {
        return this.screen.explorerPanelDraggable;
    }

    @Override
    public final void onComplete(TFileChooserResult result) {
        this.screen.selectedFile = result.getReturnValue() == TFileChooserResult.ReturnValue.APPROVE_OPTION ? result.getSelectedFile() : null;
        this.screen.close();
    }
}

