/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.menu.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.event.TEvent;
import io.github.thecsdev.tcdcommons.api.event.TEventFactory;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.interfaces.IEnableStateProviderSetter;
import io.github.thecsdev.tcdcommons.client.mixin.hooks.AccessorPressableWidget;
import net.minecraft.class_2960;
import net.minecraft.class_8666;

public abstract class TClickableWidget
extends TElement
implements IEnableStateProviderSetter {
    public static final int BUTTON_TEXTURE_SLICE_SIZE = 3;
    public static final class_8666 BUTTON_TEXTURES = AccessorPressableWidget.getButtonTextures();
    public static final class_2960 T_WIDGETS_TEXTURE = new class_2960(TCDCommons.getModID(), "textures/gui/widgets.png");
    protected boolean enabled = true;
    public TEvent<TClickableWidgetEvent_Clicked> eClicked = TEventFactory.createLoop(new TClickableWidgetEvent_Clicked[0]);

    public TClickableWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    @Virtual
    public boolean isFocusable() {
        return this.enabled;
    }

    @Override
    public final boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @Virtual
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void click(boolean playClickSound) {
        if (playClickSound) {
            GuiUtils.playClickSound();
        }
        this.onClick();
        this.eClicked.invoker().invoke(this);
    }

    protected abstract void onClick();

    @Override
    public boolean input(TInputContext inputContext) {
        if (super.input(inputContext)) {
            return true;
        }
        if (this.getParentTScreen() == null) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (inputContext.getInputType()) {
            case MOUSE_PRESS: {
                int btn = inputContext.getMouseButton();
                if (btn == 0) {
                    this.click(true);
                    return true;
                }
                if (btn == 1) {
                    TContextMenuPanel contextMenu = this.createContextMenu();
                    if (contextMenu != null) {
                        contextMenu.open();
                        GuiUtils.playClickSound();
                        return true;
                    }
                    return false;
                }
                return false;
            }
            case KEY_RELEASE: {
                int keyCode = inputContext.getKeyboardKey().keyCode;
                if (keyCode != 257 && keyCode != 335) break;
                this.click(true);
                return true;
            }
        }
        return false;
    }

    public static interface TClickableWidgetEvent_Clicked {
        public void invoke(TClickableWidget var1);
    }
}

