/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class HookedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> delegate;
    private final Consumer<Map<K, V>> accessHook;

    private HookedMap(Map<K, V> delegate, Consumer<Map<K, V>> accessHook) {
        this.delegate = delegate;
        this.accessHook = accessHook;
    }

    private void invokeHook() {
        if (this.accessHook != null) {
            this.accessHook.accept(this.delegate);
        }
    }

    public static <K, V> Map<K, V> of(Map<K, V> map, Consumer<Map<K, V>> accessHook) {
        return new HookedMap<K, V>(map, accessHook);
    }

    @Override
    public final V get(Object key) {
        this.invokeHook();
        return this.delegate.get(key);
    }

    @Override
    public final V put(K key, V value) {
        this.invokeHook();
        return this.delegate.put(key, value);
    }

    @Override
    public final int size() {
        this.invokeHook();
        return this.delegate.size();
    }

    @Override
    public final boolean isEmpty() {
        this.invokeHook();
        return this.delegate.isEmpty();
    }

    @Override
    public final boolean containsKey(Object key) {
        this.invokeHook();
        return this.delegate.containsKey(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        this.invokeHook();
        return this.delegate.containsValue(value);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.invokeHook();
        this.delegate.putAll(m);
    }

    @Override
    public final V remove(Object key) {
        this.invokeHook();
        return this.delegate.remove(key);
    }

    @Override
    public final void clear() {
        this.invokeHook();
        this.delegate.clear();
    }

    @Override
    public final Set<K> keySet() {
        this.invokeHook();
        return this.delegate.keySet();
    }

    @Override
    public final Collection<V> values() {
        this.invokeHook();
        return this.delegate.values();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        this.invokeHook();
        return this.delegate.entrySet();
    }
}

