/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.collections;

import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Virtual
public class IdealList<E>
extends AbstractList<E>
implements Iterable<E> {
    @ApiStatus.Internal
    private final ArrayList<Node> __nodes = new ArrayList();

    @Override
    @Virtual
    public int size() {
        return this.nodeCount();
    }

    @Override
    public final boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    @Virtual
    public void clear() {
        this.clearNodes();
    }

    @Override
    @Virtual
    public int indexOf(Object entry) {
        return this.findNode(n -> n.get() == entry).getKey();
    }

    @Override
    @Virtual
    public boolean contains(Object entry) {
        return this.indexOf(entry) >= 0;
    }

    @Override
    @Virtual
    public E get(int index) throws IndexOutOfBoundsException {
        return this.getNode(index).get();
    }

    @Override
    @Virtual
    public E set(int index, E element) throws IndexOutOfBoundsException {
        Node node = this.getNode(index);
        Object old = node.get();
        node.set(element);
        return old;
    }

    @Override
    public final boolean add(E element) {
        return this.addB(this.size(), element);
    }

    @Override
    public final void add(int index, E element) throws IndexOutOfBoundsException, UnsupportedOperationException {
        if (!this.addB(index, element)) {
            throw new UnsupportedOperationException();
        }
    }

    @Virtual
    public boolean addB(int index, E element) throws IndexOutOfBoundsException {
        this.addNode(index, new Node(element));
        return true;
    }

    @Override
    public final boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index < 0) {
            return false;
        }
        return this.removeB(index);
    }

    @Override
    public final E remove(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        Object prev = this.getNode(index).get();
        if (!this.removeB(index)) {
            throw new UnsupportedOperationException();
        }
        return prev;
    }

    @Virtual
    public boolean removeB(int index) throws IndexOutOfBoundsException {
        this.removeNode(index);
        return true;
    }

    @Override
    public final Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public final ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @Virtual
    public ListIterator<E> listIterator(int index) throws IndexOutOfBoundsException {
        this.forEachNode(null);
        return new IdealListIterator(index);
    }

    public final E find(Predicate<E> predicate) {
        for (E element : this) {
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    protected final int nodeCount() {
        return this.__nodes.size();
    }

    protected final int indexOfNode(Node node) {
        return this.__nodes.indexOf(node);
    }

    protected final void clearNodes() {
        this.forEachNode(n -> n.setRemoved());
        this.__nodes.clear();
        this.__nodes.trimToSize();
    }

    protected final Node getNode(int index) throws IndexOutOfBoundsException {
        return this.__nodes.get(index);
    }

    @Nullable
    protected final Node getNodeOrDefault(int index) {
        if (this.__nodes.isEmpty()) {
            return null;
        }
        if (index >= 0 && index < this.__nodes.size()) {
            return this.__nodes.get(index);
        }
        return null;
    }

    protected final void addNode(int index, Node node) throws NullPointerException, IndexOutOfBoundsException {
        Objects.requireNonNull(node);
        Node prev = this.getNodeOrDefault(index - 1);
        Node next = this.getNodeOrDefault(index);
        this.__nodes.add(index, node);
        node.isRemoved = false;
        node.previous = prev;
        node.next = next;
        if (prev != null) {
            prev.next = node;
        }
        if (next != null) {
            next.previous = node;
        }
    }

    protected final void removeNode(int index) throws IndexOutOfBoundsException {
        Node node = this.__nodes.get(index);
        Node prev = this.getNodeOrDefault(index - 1);
        Node next = this.getNodeOrDefault(index + 1);
        this.__nodes.remove(index);
        node.setRemoved();
        if (prev != null) {
            prev.next = next;
        }
        if (next != null) {
            next.previous = prev;
        }
    }

    protected final void forEachNode(Consumer<Node> action) {
        this.findNode(n -> {
            if (action != null) {
                action.accept((Node)n);
            }
            return false;
        });
    }

    protected final Map.Entry<Integer, Node> findNode(Function<Node, Boolean> action) {
        if (this.__nodes.isEmpty()) {
            return new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
        }
        this.getFirstNode().previous = null;
        Node lastNode = null;
        int index = -1;
        for (Node node : this.__nodes) {
            ++index;
            if (lastNode != null) {
                lastNode.next = node;
            }
            boolean accepted = action != null && action.apply(node) != false;
            lastNode = node;
            if (!accepted) continue;
            return new AbstractMap.SimpleEntry<Integer, Node>(index, node);
        }
        lastNode.next = null;
        return new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
    }

    @Nullable
    protected final Node getFirstNode() {
        return this.getNodeOrDefault(0);
    }

    @Nullable
    protected final Node getLastNode() {
        return this.getNodeOrDefault(this.__nodes.size() - 1);
    }

    protected final class Node {
        @Nullable
        protected volatile Node previous = null;
        @Nullable
        protected volatile Node next = null;
        @Nullable
        protected volatile E entry = null;
        private volatile boolean isRemoved = false;

        public Node() {
        }

        public Node(E element) {
            this.entry = element;
        }

        @Nullable
        public final E get() {
            return this.entry;
        }

        public final void set(@Nullable E element) {
            this.entry = element;
        }

        public final boolean isRemoved() {
            return this.isRemoved;
        }

        protected final void setRemoved() {
            this.isRemoved = true;
        }

        @Nullable
        public final Node getPrevious() {
            return this.previous;
        }

        @Nullable
        public final Node getNext() {
            return this.next;
        }

        @Nullable
        public final Node findPrevious() {
            Node i;
            if (this.previous == null) {
                return null;
            }
            Node prev = this.previous;
            while (prev.isRemoved() && (i = prev.previous) != null) {
                prev = i;
            }
            if (prev.isRemoved()) {
                if (!this.isRemoved()) {
                    return null;
                }
                prev = this;
                while (prev.isRemoved() && (i = prev.next) != null) {
                    prev = i;
                }
                if (prev.isRemoved()) {
                    return null;
                }
                return prev.findPrevious();
            }
            return prev;
        }

        @Nullable
        public final Node findNext() {
            Node i;
            if (this.next == null) {
                return null;
            }
            Node next = this.next;
            while (next.isRemoved() && (i = next.next) != null) {
                next = i;
            }
            if (next.isRemoved()) {
                if (!this.isRemoved()) {
                    return null;
                }
                next = this;
                while (next.isRemoved() && (i = next.previous) != null) {
                    next = i;
                }
                if (next.isRemoved()) {
                    return null;
                }
                return next.findNext();
            }
            return next;
        }
    }

    protected final class IdealListIterator
    implements ListIterator<E> {
        private volatile Node cursor;

        public IdealListIterator() {
            this(0);
        }

        public IdealListIterator(int startingNodeIndex) throws IndexOutOfBoundsException {
            this.cursor = new Node();
            if (IdealList.this.nodeCount() >= 1) {
                if (startingNodeIndex == IdealList.this.nodeCount()) {
                    this.cursor.previous = IdealList.this.getLastNode();
                } else {
                    Node startingNode;
                    this.cursor.next = startingNode = IdealList.this.getNode(startingNodeIndex);
                    if (startingNode != null) {
                        this.cursor.previous = startingNode.previous;
                    }
                }
            }
        }

        public final int findCursorIndex() {
            return IdealList.this.indexOfNode(this.cursor);
        }

        @Override
        public void set(E e) {
            this.cursor.set(e);
        }

        @Override
        public void add(E e) {
            int index = this.findCursorIndex();
            Node node = new Node(e);
            IdealList.this.addNode(index, node);
            this.cursor = node;
        }

        @Override
        public void remove() throws IndexOutOfBoundsException {
            IdealList.this.removeNode(this.findCursorIndex());
            if (!this.cursor.isRemoved()) {
                throw new IllegalStateException("The cursor node didn't get removed. This shouldn't happen, but since it did, something has gone seriously wrong.");
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor.findNext() != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor.findPrevious() != null;
        }

        @Override
        public int previousIndex() {
            int i = this.findCursorIndex();
            if (i < 0) {
                return i;
            }
            return i - 1;
        }

        @Override
        public int nextIndex() {
            int i = this.findCursorIndex();
            if (i < 0) {
                return i;
            }
            return i + 1;
        }

        @Override
        public E previous() throws NoSuchElementException {
            Node prev = this.cursor.findPrevious();
            if (prev == null) {
                throw new NoSuchElementException();
            }
            this.cursor = prev;
            return this.cursor.get();
        }

        @Override
        public E next() throws NoSuchElementException {
            Node next = this.cursor.findNext();
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.cursor = next;
            return this.cursor.get();
        }
    }
}

