/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.cache;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public final class CachedResource<R> {
    private final R resource;
    private final long resourceSizeB;
    private final Instant expirationDate;

    public CachedResource(R resource, long resourceSizeB, Instant expirationDate) throws NullPointerException {
        this.resource = Objects.requireNonNull(resource);
        this.resourceSizeB = Math.max(resourceSizeB, 0L);
        this.expirationDate = CachedResource.clampExpirationDate(expirationDate);
    }

    public final Class<R> getResourceType() {
        return this.resource.getClass();
    }

    public final R getResource() {
        return this.resource;
    }

    public final long getResourceSizeB() {
        return this.resourceSizeB;
    }

    public final Instant getExpirationDate() {
        return this.expirationDate;
    }

    public static final CachedResource<String> ofString(String text, Instant expirationDate) throws NullPointerException {
        Objects.requireNonNull(text);
        Objects.requireNonNull(expirationDate);
        int textSize = 40 + text.getBytes(StandardCharsets.UTF_16).length;
        return new CachedResource<String>(text, textSize, expirationDate);
    }

    public static final CachedResource<byte[]> ofBytes(byte[] bytes, Instant expirationDate) throws NullPointerException {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(expirationDate);
        int size = 16 + bytes.length;
        return new CachedResource<byte[]>(bytes, size, expirationDate);
    }

    private static final Instant clampExpirationDate(Instant expirationDate) {
        Objects.requireNonNull(expirationDate);
        Instant now = Instant.now();
        if (expirationDate.isAfter(now.plus(Duration.ofDays(32L)))) {
            return now.plus(Duration.ofDays(31L));
        }
        return expirationDate;
    }
}

