/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.cache;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public abstract class CachedResourceSerializer<T> {
    private final Class<T> type;

    public CachedResourceSerializer(Class<T> type) throws NullPointerException {
        this.type = Objects.requireNonNull(type);
    }

    public final Class<T> getResourceType() {
        return this.type;
    }

    public final void serialize(T value, OutputStream stream) throws NullPointerException, IllegalArgumentException, IOException {
        Objects.requireNonNull(value);
        Objects.requireNonNull(stream);
        if (!Objects.equals(this.type, value.getClass())) {
            throw new IllegalArgumentException(String.format("Illegal value type; Expected '%s', got '%s'.", this.type.getName(), value.getClass().getName()));
        }
        this.onSerialize(value, stream);
    }

    public final T deserialize(InputStream stream) throws NullPointerException, IOException {
        Objects.requireNonNull(stream);
        Object result = null;
        try {
            result = Objects.requireNonNull(this.onDeserialize(stream));
        }
        catch (NullPointerException npe) {
            throw new IOException("Deserialization returned null.", npe);
        }
        if (!Objects.equals(this.type, result.getClass())) {
            throw new IOException(String.format("Deserialization returned an illegal type; Expected '%s', got '%s'.", this.type.getClass().getName(), result.getClass().getName()), new ClassCastException());
        }
        return (T)result;
    }

    protected abstract void onSerialize(T var1, OutputStream var2) throws IOException;

    protected abstract T onDeserialize(InputStream var1) throws IOException;

    public static final void init() {
    }

    static {
        String modId = TCDCommons.getModID();
        TRegistries.CACHED_RESOURCE_SERIALIZER.register(new class_2960(modId, String.class.getName().toLowerCase().replace('.', '/')), new CachedResourceSerializer<String>(String.class){

            @Override
            protected final void onSerialize(String value, OutputStream stream) throws IOException {
                if (value == null) {
                    value = "";
                }
                stream.write(value.getBytes(StandardCharsets.UTF_16));
            }

            @Override
            protected final String onDeserialize(InputStream stream) throws IOException {
                return new String(stream.readAllBytes(), StandardCharsets.UTF_16);
            }
        });
        TRegistries.CACHED_RESOURCE_SERIALIZER.register(new class_2960(modId, "byte_array"), new CachedResourceSerializer<byte[]>(byte[].class){

            @Override
            protected final void onSerialize(byte[] value, OutputStream stream) throws IOException {
                if (value == null) {
                    value = new byte[]{};
                }
                stream.write(value);
            }

            @Override
            protected final byte[] onDeserialize(InputStream stream) throws IOException {
                return stream.readAllBytes();
            }
        });
        TRegistries.CACHED_RESOURCE_SERIALIZER.register(new class_2960(modId, JsonObject.class.getName().toLowerCase().replace('.', '/')), new CachedResourceSerializer<JsonObject>(JsonObject.class){

            @Override
            protected final void onSerialize(JsonObject value, OutputStream stream) throws IOException {
                try {
                    String json = TCDCommons.GSON.toJson((JsonElement)value);
                    stream.write(json.getBytes(StandardCharsets.UTF_16));
                }
                catch (Exception e) {
                    throw new IOException("Failed to serialize JsonObject.", e);
                }
            }

            @Override
            protected final JsonObject onDeserialize(InputStream stream) throws IOException {
                try {
                    String json = new String(stream.readAllBytes(), StandardCharsets.UTF_16);
                    if (StringUtils.isBlank((CharSequence)json)) {
                        json = "{}";
                    }
                    return (JsonObject)TCDCommons.GSON.fromJson(json, JsonObject.class);
                }
                catch (Exception e) {
                    throw new IOException("Failed to deserialize JsonObject.", e);
                }
            }
        });
        TRegistries.CACHED_RESOURCE_SERIALIZER.register(new class_2960(modId, JsonArray.class.getName().toLowerCase().replace('.', '/')), new CachedResourceSerializer<JsonArray>(JsonArray.class){

            @Override
            protected final void onSerialize(JsonArray value, OutputStream stream) throws IOException {
                try {
                    String json = TCDCommons.GSON.toJson((JsonElement)value);
                    stream.write(json.getBytes(StandardCharsets.UTF_16));
                }
                catch (Exception e) {
                    throw new IOException("Failed to serialize JsonArray.", e);
                }
            }

            @Override
            protected final JsonArray onDeserialize(InputStream stream) throws IOException {
                try {
                    String json = new String(stream.readAllBytes(), StandardCharsets.UTF_16);
                    if (StringUtils.isBlank((CharSequence)json)) {
                        json = "[]";
                    }
                    return (JsonArray)TCDCommons.GSON.fromJson(json, JsonArray.class);
                }
                catch (Exception e) {
                    throw new IOException("Failed to deserialize JsonArray.", e);
                }
            }
        });
    }
}

