/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.client;

import com.google.common.annotations.Beta;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.thecsdev.tcdcommons.api.util.thread.TaskScheduler;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.client.world.ClientSandboxWorld;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Beta
@ApiStatus.Internal
public final class ClientEntitySandbox {
    @Nullable
    private static final class_1937 SANDBOX_WORLD = new ClientSandboxWorld();
    private static final Cache<class_1299<?>, class_1297> ENTITY_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).expireAfterAccess(30L, TimeUnit.MINUTES).removalListener(remNotif -> {
        class_1297 entity = (class_1297)remNotif.getValue();
        if (entity != null) {
            try {
                entity.method_31472();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }).build();

    private ClientEntitySandbox() {
    }

    @Nullable
    public static class_1297 getCachedEntityFromType(class_1299<?> entityType) {
        if (entityType == class_1299.field_6097) {
            return TCDCommonsClient.MC_CLIENT.field_1724;
        }
        if (entityType == null || !entityType.method_5896()) {
            return null;
        }
        class_1297 existing = (class_1297)ENTITY_CACHE.getIfPresent(entityType);
        if (existing != null) {
            return existing;
        }
        class_1297 newEntity = null;
        try {
            newEntity = entityType.method_5883(SANDBOX_WORLD);
        }
        catch (Exception e) {
            newEntity = class_1299.field_33456.method_5883(SANDBOX_WORLD);
        }
        try {
            newEntity.method_31472();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newEntity != null) {
            ENTITY_CACHE.put(entityType, (Object)newEntity);
        }
        return newEntity;
    }

    static {
        TaskScheduler.schedulePeriodicCacheCleanup(ENTITY_CACHE);
    }
}

