/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common;

import com.illusivesoulworks.polymorph.common.network.client.CPacketBlockEntityListener;
import com.illusivesoulworks.polymorph.common.network.client.CPacketPersistentRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.client.CPacketPlayerRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.client.CPacketStackRecipeSelection;
import com.illusivesoulworks.polymorph.common.network.server.SPacketBlockEntityRecipeSync;
import com.illusivesoulworks.polymorph.common.network.server.SPacketHighlightRecipe;
import com.illusivesoulworks.polymorph.common.network.server.SPacketPlayerRecipeSync;
import com.illusivesoulworks.polymorph.common.network.server.SPacketRecipesList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PolymorphFabricNetwork {
    public static void setup() {
        PolymorphFabricNetwork.registerServerReceiver(CPacketPlayerRecipeSelection.ID, CPacketPlayerRecipeSelection::new, CPacketPlayerRecipeSelection::handle);
        PolymorphFabricNetwork.registerServerReceiver(CPacketPersistentRecipeSelection.ID, CPacketPersistentRecipeSelection::new, CPacketPersistentRecipeSelection::handle);
        PolymorphFabricNetwork.registerServerReceiver(CPacketStackRecipeSelection.ID, CPacketStackRecipeSelection::new, CPacketStackRecipeSelection::handle);
        PolymorphFabricNetwork.registerServerReceiver(CPacketBlockEntityListener.ID, CPacketBlockEntityListener::new, CPacketBlockEntityListener::handle);
    }

    public static void clientSetup() {
        PolymorphFabricNetwork.registerClientReceiver(SPacketHighlightRecipe.ID, SPacketHighlightRecipe::new, SPacketHighlightRecipe::handle);
        PolymorphFabricNetwork.registerClientReceiver(SPacketPlayerRecipeSync.ID, SPacketPlayerRecipeSync::new, SPacketPlayerRecipeSync::handle);
        PolymorphFabricNetwork.registerClientReceiver(SPacketRecipesList.ID, SPacketRecipesList::new, SPacketRecipesList::handle);
        PolymorphFabricNetwork.registerClientReceiver(SPacketBlockEntityRecipeSync.ID, SPacketBlockEntityRecipeSync::new, SPacketBlockEntityRecipeSync::handle);
    }

    private static <M> void registerServerReceiver(class_2960 resourceLocation, Function<class_2540, M> decoder, BiConsumer<M, class_3222> handler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)resourceLocation, (server, player, listener, buf, responseSender) -> {
            Object packet = decoder.apply(buf);
            server.execute(() -> handler.accept(packet, player));
        });
    }

    private static <M> void registerClientReceiver(class_2960 resourceLocation, Function<class_2540, M> decoder, Consumer<M> handler) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)resourceLocation, (client, listener, buf, responseSender) -> {
            Object packet = decoder.apply(buf);
            client.execute(() -> handler.accept(packet));
        });
    }
}

