/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.components;

import com.illusivesoulworks.polymorph.PolymorphConstants;
import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.base.IPolymorphCommon;
import com.illusivesoulworks.polymorph.api.common.base.IRecipePair;
import com.illusivesoulworks.polymorph.api.common.capability.IStackRecipeData;
import com.illusivesoulworks.polymorph.common.impl.RecipePair;
import com.mojang.datafixers.util.Pair;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_8786;

public abstract class AbstractStackRecipeDataComponent
extends ItemComponent
implements IStackRecipeData {
    private final SortedSet<IRecipePair> recipesList = new TreeSet<IRecipePair>();
    private final class_1799 owner;
    private class_8786<?> lastRecipe;
    private class_8786<?> selectedRecipe;
    private class_2960 loadedRecipe;
    private boolean isFailing;

    public AbstractStackRecipeDataComponent(class_1799 owner) {
        super(owner);
        this.owner = owner;
    }

    @Override
    public <T extends class_1860<C>, C extends class_1263> Optional<class_8786<T>> getRecipe(class_3956<T> type, C inventory, class_1937 level, List<class_8786<T>> recipesList) {
        List recipes;
        this.getLoadedRecipe().flatMap(id -> level.method_8433().method_8130(id)).ifPresent(selected -> {
            try {
                if (selected.comp_1933().method_17716() == type && (selected.comp_1933().method_8115(inventory, level) || this.isEmpty(inventory))) {
                    this.setSelectedRecipe((class_8786<?>)selected);
                }
            }
            catch (ClassCastException e) {
                PolymorphConstants.LOG.error("Recipe {} does not match inventory {}", (Object)selected.comp_1932(), (Object)inventory);
            }
            this.loadedRecipe = null;
        });
        if (this.isEmpty(inventory)) {
            this.setFailing(false);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        this.getLastRecipe().ifPresent(recipe -> {
            try {
                if (recipe.comp_1933().method_17716() == type && recipe.comp_1933().method_8115(inventory, level)) {
                    this.getSelectedRecipe().ifPresent(selected -> {
                        try {
                            if (selected.comp_1933().method_17716() == type && selected.comp_1933().method_8115(inventory, level)) {
                                ref.set(selected);
                            }
                        }
                        catch (ClassCastException e) {
                            PolymorphConstants.LOG.error("Recipe {} does not match inventory {}", (Object)selected.comp_1932(), (Object)inventory);
                        }
                    });
                }
            }
            catch (ClassCastException e) {
                PolymorphConstants.LOG.error("Recipe {} does not match inventory {}", (Object)recipe.comp_1932(), (Object)inventory);
            }
        });
        class_8786 result = ref.get();
        if (result != null) {
            this.setFailing(false);
            this.sendRecipesListToListeners(false);
            return Optional.of(result);
        }
        TreeSet<IRecipePair> newDataset = new TreeSet<IRecipePair>();
        List list = recipes = recipesList.isEmpty() ? level.method_8433().method_17877(type, inventory, level) : recipesList;
        if (recipes.isEmpty()) {
            this.setFailing(true);
            this.sendRecipesListToListeners(true);
            return Optional.empty();
        }
        for (class_8786 entry : recipes) {
            class_2960 id2 = entry.comp_1932();
            if (ref.get() == null && this.getSelectedRecipe().map(recipe -> recipe.comp_1932().equals((Object)id2)).orElse(false).booleanValue()) {
                ref.set(entry);
            }
            newDataset.add(new RecipePair(id2, entry.comp_1933().method_8116(inventory, level.method_30349())));
        }
        this.setRecipesList(newDataset);
        result = ref.get();
        this.lastRecipe = result = result != null ? result : (class_8786)recipes.get(0);
        this.setSelectedRecipe(result);
        this.setFailing(false);
        this.sendRecipesListToListeners(false);
        return Optional.of(result);
    }

    @Override
    public Optional<class_8786<?>> getSelectedRecipe() {
        return Optional.ofNullable(this.selectedRecipe);
    }

    @Override
    public void setSelectedRecipe(@Nonnull class_8786<?> recipe) {
        this.selectedRecipe = recipe;
    }

    public Optional<class_8786<?>> getLastRecipe() {
        return Optional.ofNullable(this.lastRecipe);
    }

    public Optional<class_2960> getLoadedRecipe() {
        return Optional.ofNullable(this.loadedRecipe);
    }

    @Override
    @Nonnull
    public SortedSet<IRecipePair> getRecipesList() {
        return this.recipesList;
    }

    @Override
    public void setRecipesList(@Nonnull SortedSet<IRecipePair> recipesList) {
        this.recipesList.clear();
        this.recipesList.addAll(recipesList);
    }

    @Override
    public boolean isEmpty(class_1263 inventory) {
        if (inventory != null) {
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (inventory.method_5438(i).method_7960()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public class_1799 getOwner() {
        return this.owner;
    }

    @Override
    public void selectRecipe(@Nonnull class_8786<?> recipe) {
        this.setSelectedRecipe(recipe);
    }

    @Override
    public Set<class_3222> getListeners() {
        HashSet<class_3222> players = new HashSet<class_3222>();
        IPolymorphCommon commonApi = PolymorphApi.common();
        commonApi.getServer().ifPresent(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                commonApi.getRecipeDataFromItemStack(player.field_7512).ifPresent(recipeData -> {
                    if (recipeData == this) {
                        players.add(player);
                    }
                });
            }
        });
        return players;
    }

    @Override
    public void sendRecipesListToListeners(boolean isEmpty) {
        Pair packetData = isEmpty ? new Pair(new TreeSet(), null) : this.getPacketData();
        for (class_3222 listener : this.getListeners()) {
            PolymorphApi.common().getPacketDistributor().sendRecipesListS2C(listener, (SortedSet)packetData.getFirst(), (class_2960)packetData.getSecond());
        }
    }

    @Override
    public Pair<SortedSet<IRecipePair>, class_2960> getPacketData() {
        return new Pair(this.getRecipesList(), null);
    }

    @Override
    public boolean isFailing() {
        return this.isFailing;
    }

    @Override
    public void setFailing(boolean isFailing) {
        this.isFailing = isFailing;
    }

    @Override
    public void readNBT(class_2487 compoundTag) {
        if (compoundTag.method_10545("SelectedRecipe")) {
            this.loadedRecipe = new class_2960(compoundTag.method_10558("SelectedRecipe"));
        }
        if (compoundTag.method_10545("RecipeDataSet")) {
            SortedSet<IRecipePair> dataset = this.getRecipesList();
            dataset.clear();
            class_2499 list = compoundTag.method_10554("RecipeDataSet", 10);
            for (class_2520 inbt : list) {
                class_2487 tag = (class_2487)inbt;
                class_2960 id = class_2960.method_12829((String)tag.method_10558("Id"));
                class_1799 stack = class_1799.method_7915((class_2487)tag.method_10562("ItemStack"));
                dataset.add(new RecipePair(id, stack));
            }
        }
    }

    @Override
    @Nonnull
    public class_2487 writeNBT() {
        class_2487 nbt = new class_2487();
        this.getSelectedRecipe().ifPresent(selected -> nbt.method_10582("SelectedRecipe", this.selectedRecipe.comp_1932().toString()));
        SortedSet<IRecipePair> dataset = this.getRecipesList();
        if (!dataset.isEmpty()) {
            class_2499 list = new class_2499();
            for (IRecipePair data : dataset) {
                class_2487 tag = new class_2487();
                tag.method_10566("ItemStack", (class_2520)data.getOutput().method_7953(new class_2487()));
                tag.method_10582("Id", data.getResourceLocation().toString());
                list.add((Object)tag);
            }
            nbt.method_10566("RecipeDataSet", (class_2520)list);
        }
        return nbt;
    }
}

