/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.crafting;

import com.illusivesoulworks.polymorph.api.PolymorphApi;
import com.illusivesoulworks.polymorph.api.common.capability.IBlockEntityRecipeData;
import com.illusivesoulworks.polymorph.api.common.capability.IPlayerRecipeData;
import com.illusivesoulworks.polymorph.api.common.capability.IRecipeData;
import com.illusivesoulworks.polymorph.api.common.capability.IStackRecipeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_3956;
import net.minecraft.class_8786;

public class RecipeSelection {
    private static <T extends class_1860<C>, C extends class_1263> Optional<class_8786<T>> getDefaultRecipe(class_3956<T> type, C inventory, class_1937 level) {
        return level.method_8433().method_8132(type, inventory, level);
    }

    public static <T extends class_1860<C>, C extends class_1263> Optional<class_8786<T>> getPlayerRecipe(class_1703 containerMenu, class_3956<T> type, C inventory, class_1937 level, List<class_1735> slots) {
        class_1657 player = null;
        for (class_1735 slot : slots) {
            class_1263 class_12632 = slot.field_7871;
            if (!(class_12632 instanceof class_1661)) continue;
            class_1661 inv = (class_1661)class_12632;
            player = inv.field_7546;
            break;
        }
        if (player != null) {
            return RecipeSelection.getPlayerRecipe(containerMenu, type, inventory, level, player, new ArrayList<class_8786<T>>());
        }
        return level.method_8433().method_17877(type, inventory, level).stream().findFirst();
    }

    public static <T extends class_1860<C>, C extends class_1263> Optional<class_8786<T>> getPlayerRecipe(class_1703 containerMenu, class_3956<T> type, C inventory, class_1937 level, class_1657 player) {
        return RecipeSelection.getPlayerRecipe(containerMenu, type, inventory, level, player, new ArrayList<class_8786<T>>());
    }

    public static <T extends class_1860<C>, C extends class_1263> Optional<class_8786<T>> getPlayerRecipe(class_1703 containerMenu, class_3956<T> type, C inventory, class_1937 level, class_1657 player, List<class_8786<T>> recipes) {
        Optional<? extends IPlayerRecipeData> maybeData = PolymorphApi.common().getRecipeData(player);
        maybeData.ifPresent(playerRecipeData -> playerRecipeData.setContainerMenu(containerMenu));
        return RecipeSelection.getRecipe(type, inventory, level, maybeData, recipes);
    }

    public static <T extends class_1860<C>, C extends class_1263> Optional<class_8786<T>> getStackRecipe(class_3956<T> type, C inventory, class_1937 level, class_1799 stack) {
        Optional<? extends IStackRecipeData> maybeData = PolymorphApi.common().getRecipeData(stack);
        return RecipeSelection.getRecipe(type, inventory, level, maybeData, new ArrayList<class_8786<T>>());
    }

    public static <T extends class_1860<C>, C extends class_1263> Optional<class_8786<T>> getBlockEntityRecipe(class_3956<T> type, C inventory, class_1937 level, class_2586 blockEntity) {
        Optional<? extends IBlockEntityRecipeData> maybeData = PolymorphApi.common().getRecipeData(blockEntity);
        return RecipeSelection.getRecipe(type, inventory, level, maybeData, new ArrayList<class_8786<T>>());
    }

    private static <T extends class_1860<C>, C extends class_1263> Optional<class_8786<T>> getRecipe(class_3956<T> type, C inventory, class_1937 level, Optional<? extends IRecipeData<?>> pOpt, List<class_8786<T>> recipes) {
        if (pOpt.isPresent()) {
            return pOpt.flatMap(recipeData -> recipeData.getRecipe(type, inventory, level, recipes));
        }
        return level.method_8433().method_17877(type, inventory, level).stream().findFirst();
    }
}

