/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.prism.util;

import com.anthonyhilyard.prism.text.DynamicColor;
import com.anthonyhilyard.prism.util.ConfigHelper;
import com.anthonyhilyard.prism.util.IColor;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class WebColors {
    private static final Map<String, IColor> webColorMap;

    public static IColor getColor(String colorName) {
        colorName = ConfigHelper.formatColorName(colorName);
        DynamicColor result = null;
        if (webColorMap.containsKey(colorName)) {
            result = DynamicColor.fromColor(webColorMap.get(colorName));
        }
        return result;
    }

    static {
        HashMap loadedColors = Maps.newHashMap();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(WebColors.class.getClassLoader().getResourceAsStream("webcolors.csv")));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] components = line.split(",");
                if (components.length < 2) continue;
                final String name = components[0];
                final int value = Integer.parseUnsignedInt(components[1], 16);
                loadedColors.put(ConfigHelper.formatColorName(name), new IColor(){

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public int method_27716() {
                        return value;
                    }

                    @Override
                    public boolean isAnimated() {
                        return false;
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        webColorMap = Map.copyOf(loadedColors);
    }
}

