/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.drop;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jeresources.api.conditionals.Conditional;
import jeresources.api.util.ItemHelper;
import jeresources.api.util.LootConditionHelper;
import jeresources.api.util.LootFunctionHelper;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5341;
import org.jetbrains.annotations.NotNull;

public class LootDrop
implements Comparable<LootDrop> {
    public int minDrop;
    public int maxDrop;
    public class_1799 item;
    public class_1799 smeltedItem;
    public float chance;
    private Set<Conditional> conditionals;
    public int fortuneLevel;
    public boolean enchanted;
    private float sortIndex;

    public LootDrop(class_1799 item) {
        this(item, item.method_7947());
    }

    public LootDrop(class_1799 item, float chance) {
        this(item, chance, 0);
    }

    public LootDrop(class_1799 item, float chance, int fortuneLevel) {
        this(item, (int)Math.floor(chance), (int)Math.ceil(chance), chance, fortuneLevel, new Conditional[0]);
    }

    public LootDrop(class_1799 item, int minDrop, int maxDrop, Conditional ... conditionals) {
        this(item, minDrop, maxDrop, 1.0f, 0, conditionals);
    }

    public LootDrop(class_1799 item, int minDrop, int maxDrop, float chance, int fortuneLevel, Conditional ... conditionals) {
        this.item = item;
        this.smeltedItem = null;
        this.minDrop = minDrop;
        this.maxDrop = maxDrop;
        this.chance = chance;
        this.sortIndex = Math.min(chance, 1.0f) * (float)(minDrop + maxDrop);
        this.conditionals = new HashSet<Conditional>();
        Collections.addAll(this.conditionals, conditionals);
        this.fortuneLevel = fortuneLevel;
    }

    public LootDrop(class_1792 item, int minDrop, int maxDrop, Conditional ... conditionals) {
        this(new class_1799((class_1935)item), minDrop, maxDrop, 1.0f, 0, conditionals);
    }

    public LootDrop(class_1792 item, class_2487 tag, int minDrop, int maxDrop, Conditional ... conditionals) {
        this(ItemHelper.itemStackWithTag(item, 1, tag), minDrop, maxDrop, 1.0f, 0, conditionals);
    }

    public LootDrop(class_1792 item, int minDrop, int maxDrop, float chance, Conditional ... conditionals) {
        this(new class_1799((class_1935)item), minDrop, maxDrop, chance, 0, conditionals);
    }

    public LootDrop(class_1792 item, class_2487 tag, int minDrop, int maxDrop, float chance, Conditional ... conditionals) {
        this(ItemHelper.itemStackWithTag(item, 1, tag), minDrop, maxDrop, chance, 0, conditionals);
    }

    public LootDrop(class_1799 item, int minDrop, int maxDrop, float chance, Conditional ... conditionals) {
        this(item, minDrop, maxDrop, chance, 0, conditionals);
    }

    public LootDrop(class_1792 item, float chance, class_117 ... lootFunctions) {
        this(new class_1799((class_1935)item), chance);
        this.enchanted = false;
        this.addLootFunctions(lootFunctions);
    }

    public LootDrop(class_1792 item, float chance, Collection<class_117> lootFunctions) {
        this(new class_1799((class_1935)item), chance);
        this.enchanted = false;
        this.addLootFunctions(lootFunctions);
    }

    public LootDrop(class_1792 item, float chance, class_5341[] lootConditions, class_117 ... lootFunctions) {
        this(item, chance, lootFunctions);
        this.addLootConditions(lootConditions);
    }

    public LootDrop(class_1792 item, float chance, Collection<class_5341> lootConditions, class_117 ... lootFunctions) {
        this(item, chance, lootFunctions);
        this.addLootConditions(lootConditions);
    }

    public LootDrop(class_1792 item, float chance, Collection<class_5341> lootConditions, Collection<class_117> lootFunctions) {
        this(item, chance, lootFunctions);
        this.addLootConditions(lootConditions);
    }

    public LootDrop addLootConditions(class_5341[] lootConditions) {
        return this.addLootConditions(Arrays.asList(lootConditions));
    }

    public LootDrop addLootConditions(Collection<class_5341> lootConditions) {
        lootConditions.forEach(this::addLootCondition);
        return this;
    }

    public LootDrop addLootCondition(class_5341 condition) {
        LootConditionHelper.applyCondition(condition, this);
        return this;
    }

    public LootDrop addLootFunctions(class_117[] lootFunctions) {
        return this.addLootFunctions(Arrays.asList(lootFunctions));
    }

    public LootDrop addLootFunctions(Collection<class_117> lootFunctions) {
        lootFunctions.forEach(this::addLootFunction);
        return this;
    }

    public LootDrop addLootFunction(class_117 lootFunction) {
        LootFunctionHelper.applyFunction(lootFunction, this);
        return this;
    }

    public boolean canBeCooked() {
        return this.smeltedItem != null;
    }

    public List<class_1799> getDrops() {
        LinkedList<class_1799> list = new LinkedList<class_1799>();
        if (this.item != null) {
            list.add(this.item);
        }
        if (this.smeltedItem != null) {
            list.add(this.smeltedItem);
        }
        return list;
    }

    public String toString() {
        if (this.minDrop == this.maxDrop) {
            return this.minDrop + this.getDropChance();
        }
        return this.minDrop + "-" + this.maxDrop + this.getDropChance();
    }

    private String getDropChance() {
        return this.chance < 1.0f ? " (" + this.formatChance() + "%)" : "";
    }

    public String formatChance() {
        float chance = this.chance * 100.0f;
        if (chance < 10.0f) {
            return String.format("%.1f", Float.valueOf(chance));
        }
        return String.format("%2d", (int)chance);
    }

    public boolean isAffectedBy(Conditional conditional) {
        return this.conditionals.contains(conditional);
    }

    public String chanceString() {
        if (this.chance >= 0.995f) {
            return String.format("%.2G", Float.valueOf(this.chance));
        }
        return String.format("%.2G%%", Float.valueOf(this.chance * 100.0f));
    }

    public List<class_2561> getTooltipText() {
        return this.getTooltipText(false);
    }

    public List<class_2561> getTooltipText(boolean smelted) {
        List<class_2561> list = this.conditionals.stream().map(Conditional::toStringTextComponent).collect(Collectors.toList());
        if (smelted) {
            list.add(Conditional.burning.toStringTextComponent());
        }
        return list;
    }

    public void addConditional(Conditional conditional) {
        this.conditionals.add(conditional);
    }

    public void addConditionals(List<Conditional> conditionals) {
        this.conditionals.addAll(conditionals);
    }

    public float getSortIndex() {
        return this.sortIndex;
    }

    public class_2561 toStringTextComponent() {
        return class_2561.method_43470((String)this.toString());
    }

    @Override
    public int compareTo(@NotNull LootDrop o) {
        if (class_1799.method_7984((class_1799)this.item, (class_1799)o.item)) {
            return Integer.compare(o.fortuneLevel, this.fortuneLevel);
        }
        int cmp = Float.compare(o.getSortIndex(), this.getSortIndex());
        return cmp != 0 ? cmp : this.item.method_7954().toString().compareTo(o.item.method_7954().toString());
    }
}

