/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.api;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jeresources.api.IDungeonRegistry;
import jeresources.entry.DungeonEntry;
import jeresources.registry.DungeonRegistry;
import jeresources.util.LogHelper;
import jeresources.util.LootTableHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_52;
import net.minecraft.class_60;
import org.jetbrains.annotations.NotNull;

public class DungeonRegistryImpl
implements IDungeonRegistry {
    private static List<class_3545<String, String>> categoryMapping = new LinkedList<class_3545<String, String>>();
    private static Map<String, class_2960> rawRegisters = new HashMap<String, class_2960>();
    private static List<DungeonEntry> preppedRegisters = new LinkedList<DungeonEntry>();

    protected DungeonRegistryImpl() {
    }

    @Override
    public void registerCategory(@NotNull String category, @NotNull String localization) {
        categoryMapping.add((class_3545<String, String>)new class_3545((Object)category, (Object)localization));
    }

    @Override
    public void registerChest(@NotNull String category, @NotNull class_2960 tableLocation) {
        rawRegisters.put(category, tableLocation);
    }

    @Override
    public void registerChest(@NotNull String category, @NotNull class_52 lootTable) {
        try {
            preppedRegisters.add(new DungeonEntry(category, lootTable));
        }
        catch (Exception e) {
            LogHelper.debug("Bad dungeon chest registry for category %s", category);
        }
    }

    protected static void commit() {
        categoryMapping.forEach(t -> DungeonRegistry.addCategoryMapping((String)t.method_15442(), (String)t.method_15441()));
        preppedRegisters.forEach(entry -> DungeonRegistry.getInstance().registerDungeonEntry((DungeonEntry)entry));
        class_60 lootDataManager = LootTableHelper.getLootDataManager();
        rawRegisters.entrySet().stream().map(entry -> {
            try {
                return new DungeonEntry((String)entry.getKey(), lootDataManager.getLootTable((class_2960)entry.getValue()));
            }
            catch (Exception e) {
                LogHelper.debug("Bad dungeon chest registry for category %s", entry.getKey());
                return null;
            }
        }).forEach(entry -> DungeonRegistry.getInstance().registerDungeonEntry((DungeonEntry)entry));
    }
}

