/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.api;

import java.util.LinkedList;
import java.util.List;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.Restriction;
import jeresources.entry.WorldGenEntry;
import jeresources.registry.WorldGenRegistry;
import jeresources.util.LogHelper;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;

public class WorldGenRegistryImpl
implements IWorldGenRegistry {
    private static List<WorldGenEntry> registers = new LinkedList<WorldGenEntry>();
    private static List<class_3545<class_1799, LootDrop[]>> addedDrops = new LinkedList<class_3545<class_1799, LootDrop[]>>();

    protected WorldGenRegistryImpl() {
    }

    @Override
    public void register(@NotNull class_1799 block, DistributionBase distribution, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@NotNull class_1799 block, @NotNull class_1799 deepSlateBlock, DistributionBase distribution, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, deepSlateBlock, distribution, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@NotNull class_1799 block, DistributionBase distribution, Restriction restriction, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, restriction, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@NotNull class_1799 block, @NotNull class_1799 deepSlateBlock, DistributionBase distribution, Restriction restriction, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, deepSlateBlock, distribution, restriction, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@NotNull class_1799 block, DistributionBase distribution, boolean silktouch, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, silktouch, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@NotNull class_1799 block, @NotNull class_1799 deepSlateBlock, DistributionBase distribution, boolean silktouch, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, silktouch, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@NotNull class_1799 block, DistributionBase distribution, Restriction restriction, boolean silktouch, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, distribution, restriction, silktouch, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void register(@NotNull class_1799 block, @NotNull class_1799 deepSlateBlock, DistributionBase distribution, Restriction restriction, boolean silktouch, LootDrop ... drops) {
        try {
            registers.add(new WorldGenEntry(block, deepSlateBlock, distribution, restriction, silktouch, drops));
        }
        catch (Exception e) {
            LogHelper.info("Error during worldgen registry for %s", block.toString());
        }
    }

    @Override
    public void registerDrops(@NotNull class_1799 block, LootDrop ... drops) {
        if (drops.length > 0) {
            addedDrops.add((class_3545<class_1799, LootDrop[]>)new class_3545((Object)block, (Object)drops));
        }
    }

    protected static void commit() {
        for (WorldGenEntry worldGenEntry : registers) {
            WorldGenRegistry.getInstance().registerEntry(worldGenEntry);
        }
        for (class_3545 class_35452 : addedDrops) {
            WorldGenRegistry.getInstance().addDrops((class_1799)class_35452.method_15442(), (LootDrop[])class_35452.method_15441());
        }
    }
}

