/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.LinkedList;
import java.util.List;
import jeresources.profiling.EmptyChunkJER;
import jeresources.profiling.ProfilingExecutor;
import jeresources.util.LogHelper;
import net.minecraft.class_148;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_3218;

public class ChunkGetter
implements Runnable {
    public static final int CHUNKS_PER_RUN = 25;
    private final int maxRunCount;
    private final Runnable runnable;
    private IChunkGetterStrategy strategy;
    private int runCount;

    public ChunkGetter(final int chunkCount, final class_3218 level, final ProfilingExecutor executor) {
        this.maxRunCount = (int)Math.ceil((float)chunkCount / 25.0f);
        this.strategy = new ChunkGetterRandom(level);
        this.runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ChunkGetter.this.getRunCount() < ChunkGetter.this.getMaxRunCount()) {
                        List<class_2791> chunks = ChunkGetter.this.strategy.generateChunks(level);
                        if (ChunkGetter.this.strategy instanceof ChunkGetterRandom && ChunkGetter.this.areAllChunksEmpty(chunks)) {
                            ChunkGetter.this.strategy = new ChunkGetterOrigin(level, chunkCount);
                            chunks = ChunkGetter.this.strategy.generateChunks(level);
                        }
                        ++ChunkGetter.this.runCount;
                        executor.addChunkProfiler(level, chunks);
                        executor.execute(() -> level.method_8503().method_3742(ChunkGetter.this.runnable));
                    } else {
                        executor.shutdown();
                    }
                }
                catch (class_148 re) {
                    LogHelper.info("Chunk getting failed: " + re.getMessage(), new Object[0]);
                    executor.shutdown();
                }
            }
        };
    }

    @Override
    public void run() {
        this.runnable.run();
    }

    private int getMaxRunCount() {
        return this.maxRunCount;
    }

    private int getRunCount() {
        return this.runCount;
    }

    private boolean areAllChunksEmpty(List<class_2791> chunks) {
        for (class_2791 chunk : chunks) {
            if (chunk.method_12031() == 0) continue;
            return false;
        }
        return true;
    }

    private static List<class_2791> centerChunks(class_3218 level, class_2794 chunkGenerator, int chunkX, int chunkZ, int generate_size) {
        LinkedList<class_2791> centerChunks = new LinkedList<class_2791>();
        for (int i = 0; i < generate_size; ++i) {
            for (int j = 0; j < generate_size; ++j) {
                if (i <= 0 || i >= generate_size - 1 || j <= 0 || j >= generate_size - 1) continue;
                centerChunks.add((class_2791)new EmptyChunkJER(level, chunkX + i, chunkZ + j));
            }
        }
        return centerChunks;
    }

    private static class ChunkGetterRandom
    implements IChunkGetterStrategy {
        private static final int GENERATE_SIZE = (int)Math.ceil(Math.sqrt(25.0)) + 2;
        private final class_2794 chunkGenerator;

        public ChunkGetterRandom(class_3218 level) {
            this.chunkGenerator = level.method_14178().method_12129();
        }

        @Override
        public List<class_2791> generateChunks(class_3218 level) {
            class_2784 worldBorder = level.method_8621();
            int maxChunkPos = (int)(worldBorder.method_11965() / 16.0) - GENERATE_SIZE;
            int chunkX = level.field_9229.method_43048(2 * maxChunkPos) - maxChunkPos + (int)worldBorder.method_11964();
            int chunkZ = level.field_9229.method_43048(2 * maxChunkPos) - maxChunkPos + (int)worldBorder.method_11980();
            return ChunkGetter.centerChunks(level, this.chunkGenerator, chunkX, chunkZ, GENERATE_SIZE);
        }
    }

    private static interface IChunkGetterStrategy {
        public List<class_2791> generateChunks(class_3218 var1);
    }

    private static class ChunkGetterOrigin
    implements IChunkGetterStrategy {
        private static final int GENERATE_SIZE = (int)Math.ceil(Math.sqrt(25.0)) + 2;
        private final class_2794 chunkGenerator;
        private final int sideLength;
        private final int minX;
        private final int maxX;
        private int posX;
        private int posZ;

        public ChunkGetterOrigin(class_3218 level, int chunkCount) {
            this.chunkGenerator = level.method_14178().method_12129();
            this.sideLength = (int)Math.ceil(Math.sqrt(chunkCount));
            class_2784 worldBorder = level.method_8621();
            this.minX = (int)worldBorder.method_11964() - this.sideLength / 2;
            this.maxX = (int)worldBorder.method_11964() + this.sideLength / 2;
            this.posX = this.minX;
            this.posZ = (int)worldBorder.method_11980() - this.sideLength / 2;
        }

        @Override
        public List<class_2791> generateChunks(class_3218 level) {
            int chunkX = this.posX;
            int chunkZ = this.posZ;
            this.posX += GENERATE_SIZE - 1;
            if (this.posX > this.maxX) {
                this.posX = this.minX;
                this.posZ += GENERATE_SIZE - 1;
            }
            return ChunkGetter.centerChunks(level, this.chunkGenerator, chunkX, chunkZ, GENERATE_SIZE);
        }
    }
}

