/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.Restriction;
import jeresources.entry.WorldGenEntry;
import jeresources.util.LogHelper;
import jeresources.util.PlantHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class MapKeys {
    private static final Cache<class_2680, String> keyCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build();

    @Nullable
    public static String getKey(class_2680 state, class_3218 serverLevel, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (!block.method_9542(state)) {
            try {
                return (String)keyCache.get((Object)state, () -> MapKeys.getKeyUncached(block, state, serverLevel, pos));
            }
            catch (ExecutionException e) {
                LogHelper.error("Cache error", e);
            }
        }
        return MapKeys.getKeyUncached(block, state, serverLevel, pos);
    }

    @Nullable
    private static String getKeyUncached(class_2248 block, class_2680 state, class_3218 serverLevel, class_2338 pos) {
        class_1799 pickBlock = null;
        try {
            pickBlock = block.method_9574((class_4538)serverLevel, pos, state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pickBlock == null || pickBlock.method_7909() == null) {
            return block.method_9539();
        }
        return MapKeys.getKey(pickBlock);
    }

    @Nullable
    public static String getKey(class_1799 drop) {
        if (drop == null) {
            return null;
        }
        class_1792 item = drop.method_7909();
        if (item == null) {
            return null;
        }
        String registryName = item.method_7876();
        StringBuilder key = new StringBuilder(registryName);
        if (drop.method_7969() != null) {
            key.append(":").append(drop.method_7969());
        }
        return key.toString();
    }

    public static String getKey(class_2261 plant) {
        return PlantHelper.getPlant(plant, null, null).method_26204().method_9539();
    }

    public static String getKey(LootDrop dropItem) {
        return MapKeys.getKey(dropItem.item);
    }

    public static String getKey(class_1799 drop, Restriction restriction) {
        return MapKeys.getKey(drop) + ":" + restriction.toString();
    }

    public static String getKey(WorldGenEntry entry) {
        return MapKeys.getKey(entry.getBlock(), entry.getRestriction());
    }
}

