/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network.packets;

import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.packets.PacketCheatPermission;
import mezz.jei.common.network.packets.PacketJeiToServer;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ServerCommandUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketDeletePlayerItem
extends PacketJeiToServer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int itemID;

    public PacketDeletePlayerItem(class_1792 item) {
        this(Services.PLATFORM.getRegistry(class_7924.field_41197).getId(item));
    }

    public PacketDeletePlayerItem(int itemID) {
        this.itemID = itemID;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.DELETE_ITEM;
    }

    @Override
    public void writePacketData(class_2540 buf) {
        buf.method_10804(this.itemID);
    }

    public static PacketDeletePlayerItem readPacketData(class_2540 buf) {
        int itemId = buf.method_10816();
        return new PacketDeletePlayerItem(itemId);
    }

    @Override
    public void processOnServerThread(ServerPacketContext context) {
        class_1792 item = Services.PLATFORM.getRegistry(class_7924.field_41197).getValue(this.itemID).orElse(null);
        class_3222 player = context.player();
        if (item == null) {
            LOGGER.debug("Player '{} ({})' tried to delete Item ID '{}' but no item is registered with that ID.", (Object)player.method_5477(), (Object)player.method_5667(), (Object)this.itemID);
        } else {
            IServerConfig serverConfig = context.serverConfig();
            if (ServerCommandUtil.hasPermissionForCheatMode(player, serverConfig)) {
                class_1799 playerItem = player.field_7512.method_34255();
                if (playerItem.method_7909() == item) {
                    player.field_7512.method_34254(class_1799.field_8037);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Player '{} ({})' tried to delete Item '{}' but is currently holding a different ItemStack '{}'.", (Object)player.method_5477(), (Object)player.method_5667(), (Object)item, (Object)playerItem.method_7954());
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    class_1799 playerItem = player.field_7512.method_34255();
                    LOGGER.debug("Player '{} ({})' tried to delete ItemStack '{}' but does not have permission.", (Object)player.method_5477(), (Object)player.method_5667(), (Object)playerItem.method_7954());
                }
                IConnectionToClient connection = context.connection();
                connection.sendPacketToClient(new PacketCheatPermission(false), player);
            }
        }
    }
}

