/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.gui.ingredients.ListElement;
import net.minecraft.class_2371;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class IngredientListElementFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private static int ingredientAddedIndex = 0;

    private IngredientListElementFactory() {
    }

    public static class_2371<IListElement<?>> createBaseList(IIngredientManager ingredientManager) {
        class_2371 ingredientListElements = class_2371.method_10211();
        for (IIngredientType<?> ingredientType : ingredientManager.getRegisteredIngredientTypes()) {
            IngredientListElementFactory.addToBaseList(ingredientListElements, ingredientManager, ingredientType);
        }
        return ingredientListElements;
    }

    public static <V> List<IListElement<V>> createList(IIngredientManager ingredientManager, IIngredientType<V> ingredientType, Collection<V> ingredients) {
        return ingredients.stream().map(i -> ingredientManager.createTypedIngredient(ingredientType, i)).flatMap(Optional::stream).map(IngredientListElementFactory::createOrderedElement).toList();
    }

    public static <V> IListElement<V> createOrderedElement(ITypedIngredient<V> typedIngredient) {
        int orderIndex = ingredientAddedIndex++;
        return new ListElement<V>(typedIngredient, orderIndex);
    }

    private static <V> void addToBaseList(class_2371<IListElement<?>> baseList, IIngredientManager ingredientManager, IIngredientType<V> ingredientType) {
        Collection<V> ingredients = ingredientManager.getAllIngredients(ingredientType);
        LOGGER.debug("Registering ingredients: " + ingredientType.getIngredientClass().getSimpleName());
        ingredients.stream().map(i -> ingredientManager.createTypedIngredient(ingredientType, i)).flatMap(Optional::stream).map(IngredientListElementFactory::createOrderedElement).forEach(arg_0 -> baseList.add(arg_0));
    }
}

