/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class OutputSlotTooltipCallback
implements IRecipeSlotTooltipCallback {
    private final class_2960 recipeName;
    private final IModIdHelper modIdHelper;
    private final IIngredientManager ingredientManager;

    public OutputSlotTooltipCallback(class_2960 recipeName, IModIdHelper modIdHelper, IIngredientManager ingredientManager) {
        this.recipeName = recipeName;
        this.modIdHelper = modIdHelper;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public void onTooltip(IRecipeSlotView recipeSlotView, List<class_2561> tooltip) {
        boolean showAdvanced;
        if (recipeSlotView.getRole() != RecipeIngredientRole.OUTPUT) {
            return;
        }
        Optional<ITypedIngredient<?>> displayedIngredient = recipeSlotView.getDisplayedIngredient();
        if (displayedIngredient.isEmpty()) {
            return;
        }
        if (this.modIdHelper.isDisplayingModNameEnabled()) {
            String ingredientModId;
            class_2960 ingredientName = this.getResourceLocation(displayedIngredient.get());
            String recipeModId = this.recipeName.method_12836();
            if (!recipeModId.equals(ingredientModId = ingredientName.method_12836())) {
                String modName = this.modIdHelper.getFormattedModNameForModId(recipeModId);
                class_5250 recipeBy = class_2561.method_43469((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName});
                tooltip.add((class_2561)recipeBy.method_27692(class_124.field_1080));
            }
        }
        class_310 minecraft = class_310.method_1551();
        boolean bl = showAdvanced = minecraft.field_1690.field_1827 || class_437.method_25442();
        if (showAdvanced) {
            class_5250 recipeId = class_2561.method_43469((String)"jei.tooltip.recipe.id", (Object[])new Object[]{this.recipeName.toString()});
            tooltip.add((class_2561)recipeId.method_27692(class_124.field_1063));
        }
    }

    private <T> class_2960 getResourceLocation(ITypedIngredient<T> ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient.getType());
        return ingredientHelper.getResourceLocation(ingredient.getIngredient());
    }
}

