/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableAnimationController;
import fuzs.visualworkbench.world.level.block.entity.WorkbenchVisualsProvider;
import net.minecraft.class_1087;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class CraftingTableBlockEntityRenderer<T extends class_2586 & WorkbenchVisualsProvider>
implements class_827<T> {
    private final class_918 itemRenderer;

    public CraftingTableBlockEntityRenderer(class_5614.class_5615 context) {
        this.itemRenderer = context.method_43335();
    }

    public void method_3569(T blockEntity, float partialTick, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, int packedOverlay) {
        packedLight = blockEntity.method_10997() != null ? class_761.method_23794((class_1920)blockEntity.method_10997(), (class_2338)blockEntity.method_11016().method_10084()) : 0xF000F0;
        for (int i = 0; i < ((class_1263)blockEntity).method_5439(); ++i) {
            class_1799 itemStack = ((class_1263)blockEntity).method_5438(i);
            if (itemStack.method_7960()) continue;
            this.renderIngredientItem(blockEntity, partialTick, poseStack, multiBufferSource, packedLight, packedOverlay, i, itemStack);
        }
        class_1799 itemStack = ((WorkbenchVisualsProvider)blockEntity).getCraftingResult();
        if (!itemStack.method_7960()) {
            this.renderResultItem(itemStack, blockEntity.method_10997(), (float)((WorkbenchVisualsProvider)blockEntity).getAnimationController().ticks + partialTick, poseStack, multiBufferSource, packedLight);
        }
    }

    private void renderIngredientItem(T blockEntity, float partialTick, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, int packedOverlay, int i, class_1799 itemStack) {
        poseStack.method_22903();
        if (((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).flatRendering) {
            this.setupFlatRenderer(((WorkbenchVisualsProvider)blockEntity).getAnimationController(), partialTick, poseStack, itemStack, i);
        } else {
            this.setupFloatingRenderer(((WorkbenchVisualsProvider)blockEntity).getAnimationController(), partialTick, poseStack, itemStack, i);
        }
        this.itemRenderer.method_23178(itemStack, class_811.field_4319, packedLight, packedOverlay, poseStack, multiBufferSource, blockEntity.method_10997(), (int)blockEntity.method_11016().method_10063() + i);
        poseStack.method_22909();
    }

    private void setupFloatingRenderer(CraftingTableAnimationController animationController, float partialTick, class_4587 poseStack, class_1799 itemStack, int index) {
        float shift = (float)Math.abs(((double)((float)animationController.ticks + partialTick) * 50.0 + (double)((long)index * 1000L)) % 5000.0 - 2500.0) / 200000.0f;
        class_1087 model = this.itemRenderer.method_4019(itemStack, null, null, 0);
        boolean blockItem = model.method_4712();
        poseStack.method_22904(0.5, (double)shift, 0.5);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animationController.currentAngle, (float)animationController.nextAngle)));
        poseStack.method_22904((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, 1.09375, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        float scale = blockItem ? 0.24f : 0.18f;
        poseStack.method_22905(scale, scale, scale);
    }

    private void setupFlatRenderer(CraftingTableAnimationController animationController, float partialTick, class_4587 poseStack, class_1799 itemStack, int index) {
        class_1087 bakedModel = this.itemRenderer.method_4019(itemStack, null, null, 0);
        boolean gui3d = bakedModel.method_4712();
        poseStack.method_22904(0.5, 0.0, 0.5);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animationController.currentAngle, (float)animationController.nextAngle)));
        poseStack.method_22904((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, gui3d ? 1.0625 : 1.005, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        float scale = gui3d ? 0.25f : 0.175f;
        poseStack.method_22905(scale, scale, scale);
    }

    private void renderResultItem(class_1799 itemStack, @Nullable class_1937 level, float time, class_4587 poseStack, class_4597 multiBufferSource, int packedLight) {
        if (!((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).renderResult) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 1.15f, 0.5f);
        class_1087 model = this.itemRenderer.method_4019(itemStack, level, null, 0);
        float hoverOffset = class_3532.method_15374((float)(time / 10.0f)) * 0.04f + 0.1f;
        float modelYScale = model.method_4709().method_3503((class_811)class_811.field_4318).field_4285.y();
        poseStack.method_22904(0.0, (double)(hoverOffset + 0.25f * modelYScale), 0.0);
        poseStack.method_22907(class_7833.field_40716.rotation(time / 20.0f));
        if (!model.method_4712()) {
            poseStack.method_22905(0.75f, 0.75f, 0.75f);
        }
        this.itemRenderer.method_23179(itemStack, class_811.field_4318, false, poseStack, multiBufferSource, packedLight, class_4608.field_21444, model);
        poseStack.method_22909();
    }
}

