/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.handler;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fuzs.puzzleslib.api.block.v1.BlockConversionHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelper;
import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ServerConfig;
import fuzs.visualworkbench.init.ModRegistry;
import fuzs.visualworkbench.world.level.block.CraftingTableWithInventoryBlock;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2304;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7923;

public class BlockConversionHandler {
    public static final class_2561 INVALID_BLOCK_COMPONENT = class_2561.method_43471((String)"container.invalidBlock");
    public static final BiMap<class_2248, class_2248> BLOCK_CONVERSIONS = HashBiMap.create();

    public static void onRegistryEntryAdded(class_2378<class_2248> registry, class_2960 id, class_2248 block, BiConsumer<class_2960, Supplier<class_2248>> registrar) {
        if (block instanceof class_2304) {
            class_2960 resourceLocation = VisualWorkbench.id(id.method_12836() + "/" + id.method_12832());
            registrar.accept(resourceLocation, () -> {
                CraftingTableWithInventoryBlock newBlock = new CraftingTableWithInventoryBlock(block);
                BLOCK_CONVERSIONS.put((Object)block, (Object)newBlock);
                return newBlock;
            });
        }
    }

    public static EventResultHolder<class_1269> onUseBlock(class_1657 player, class_1937 level, class_1268 interactionHand, class_3965 hitResult) {
        if (!((ServerConfig)VisualWorkbench.CONFIG.get(ServerConfig.class)).disableVanillaWorkbench) {
            return EventResultHolder.pass();
        }
        class_2680 blockState = level.method_8320(hitResult.method_17777());
        if (BLOCK_CONVERSIONS.containsKey((Object)blockState.method_26204()) && !blockState.method_26164(ModRegistry.UNALTERED_WORKBENCHES_BLOCK_TAG)) {
            player.method_7353((class_2561)class_2561.method_43473().method_10852(INVALID_BLOCK_COMPONENT).method_27692(class_124.field_1061), true);
            return EventResultHolder.interrupt((Object)class_1269.method_29236((boolean)level.field_9236));
        }
        return EventResultHolder.pass();
    }

    public static void onTagsUpdated(class_5455 registryAccess, boolean client) {
        for (Map.Entry entry : class_7923.field_41178.method_29722()) {
            Object v = entry.getValue();
            if (!(v instanceof class_1747)) continue;
            class_1747 blockItem = (class_1747)v;
            class_2248 block = blockItem.method_7711();
            BlockConversionHandler.setItemForBlock(((class_5321)entry.getKey()).method_29177(), blockItem, block);
            BlockConversionHandler.setBlockForItem(blockItem, block);
        }
        BlockConversionHandler.copyBoundTags();
    }

    private static void setItemForBlock(class_2960 resourceLocation, class_1747 blockItem, class_2248 block) {
        if (block instanceof class_2304) {
            BlockConversionHelper.setItemForBlock((class_2248)((class_2248)BLOCK_CONVERSIONS.get((Object)block)), (class_1792)blockItem);
        }
    }

    private static void setBlockForItem(class_1747 blockItem, class_2248 block) {
        class_2248 baseBlock;
        class_2248 diagonalBlock = (class_2248)BLOCK_CONVERSIONS.get((Object)block);
        if (diagonalBlock != null) {
            baseBlock = block;
        } else {
            baseBlock = (class_2248)BLOCK_CONVERSIONS.inverse().get((Object)block);
            if (baseBlock != null) {
                diagonalBlock = block;
            } else {
                return;
            }
        }
        if (RegistryHelper.is(ModRegistry.UNALTERED_WORKBENCHES_BLOCK_TAG, (Object)baseBlock)) {
            BlockConversionHelper.setBlockForItem((class_1747)blockItem, (class_2248)baseBlock);
        } else {
            BlockConversionHelper.setBlockForItem((class_1747)blockItem, (class_2248)diagonalBlock);
        }
    }

    private static void copyBoundTags() {
        BLOCK_CONVERSIONS.forEach(BlockConversionHelper::copyBoundTags);
    }
}

