/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.moonconfig.core.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;

public final class FileWatcher {
    private static final long SLEEP_TIME_NANOS = 1000L;
    private static volatile FileWatcher DEFAULT_INSTANCE;
    private final Thread thread = new WatcherThread();
    private final Map<Path, WatchedDir> watchedDirs = new ConcurrentHashMap<Path, WatchedDir>();
    private final Map<Path, WatchedFile> watchedFiles = new ConcurrentHashMap<Path, WatchedFile>();
    private final Consumer<Exception> exceptionHandler;
    private final WatchService watchService;
    private volatile boolean run = true;

    public static synchronized FileWatcher defaultInstance() {
        if (DEFAULT_INSTANCE == null || !FileWatcher.DEFAULT_INSTANCE.run) {
            DEFAULT_INSTANCE = new FileWatcher();
        }
        return DEFAULT_INSTANCE;
    }

    public FileWatcher() {
        this(Throwable::printStackTrace);
    }

    public FileWatcher(Consumer<Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.thread.start();
    }

    public void addWatch(File file, Runnable changeHandler) throws IOException {
        this.addWatch(file.toPath(), changeHandler);
    }

    public void addWatch(Path file, Runnable changeHandler) throws IOException {
        file = file.toAbsolutePath();
        Path dir = file.getParent();
        this.watchedDirs.computeIfAbsent(dir, k -> new WatchedDir(dir, this.watchService));
        this.watchedFiles.computeIfAbsent(file, k -> new WatchedFile(changeHandler));
    }

    public void setWatch(File file, Runnable changeHandler) throws IOException {
        this.setWatch(file.toPath(), changeHandler);
    }

    public void setWatch(Path file, Runnable changeHandler) throws IOException {
        WatchedFile watchedFile = this.watchedFiles.get(file = file.toAbsolutePath());
        if (watchedFile == null) {
            this.addWatch(file, changeHandler);
        } else {
            watchedFile.changeHandler = changeHandler;
        }
    }

    public void removeWatch(File file) {
        this.removeWatch(file.toPath());
    }

    public void removeWatch(Path file) {
        file = file.toAbsolutePath();
        this.watchedFiles.remove(file);
    }

    public void stop() throws IOException {
        this.run = false;
        this.thread.interrupt();
        this.watchService.close();
        this.watchedDirs.clear();
        this.watchedFiles.clear();
    }

    private static final class WatchedFile {
        volatile Runnable changeHandler;

        private WatchedFile(Runnable changeHandler) {
            this.changeHandler = changeHandler;
        }
    }

    private static final class WatchedDir {
        final Path dir;

        private WatchedDir(Path dir, WatchService watchService) {
            this.dir = dir;
            try {
                dir.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class WatcherThread
    extends Thread {
        private WatcherThread() {
            this.setDaemon(true);
            this.setName("Config-Watcher");
        }

        @Override
        public void run() {
            while (FileWatcher.this.run) {
                boolean allNull = true;
                try {
                    WatchKey key = FileWatcher.this.watchService.poll(25L, TimeUnit.MILLISECONDS);
                    if (key == null) continue;
                    allNull = false;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (!FileWatcher.this.run) {
                            return;
                        }
                        if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY && event.kind() != StandardWatchEventKinds.ENTRY_CREATE && event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
                        Path childPath = (Path)event.context();
                        Path filePath = ((Path)key.watchable()).resolve(childPath);
                        WatchedFile watchedFile = (WatchedFile)FileWatcher.this.watchedFiles.get(filePath);
                        if (watchedFile == null) continue;
                        try {
                            watchedFile.changeHandler.run();
                        }
                        catch (Exception e) {
                            FileWatcher.this.exceptionHandler.accept(e);
                        }
                    }
                    key.reset();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!allNull) continue;
                LockSupport.parkNanos(1000L);
            }
        }
    }
}

