/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class WeightedCollection<E>
implements Collection<E> {
    private final NavigableMap<Double, E> map = new TreeMap<Double, E>();
    private WeightedCollectionRandom random;
    private double total = 0.0;

    public WeightedCollection() {
        this(new Random());
    }

    public WeightedCollection(Random random) {
        this(random::nextDouble);
    }

    public WeightedCollection(class_5819 random) {
        this(() -> ((class_5819)random).method_43058());
    }

    public WeightedCollection(WeightedCollectionRandom random) {
        this.random = random;
    }

    public WeightedCollection<E> add(double weight, E result) {
        if (weight <= 0.0) {
            return this;
        }
        this.total += weight;
        this.map.put(Math.min(this.total, Double.MAX_VALUE), result);
        return this;
    }

    public E get(int index) {
        Double key = (Double)new LinkedList(this.map.keySet()).get(index);
        return (E)this.map.get(key);
    }

    public E next() {
        double value = this.random.nextDouble() * this.total;
        return this.map.higherEntry(value).getValue();
    }

    public NavigableMap<Double, E> getMap() {
        return this.map;
    }

    public double getTotal() {
        return this.total;
    }

    public double getAdjustedWeight(double weight) {
        return weight / this.total;
    }

    public void forEachWithSelf(BiConsumer<WeightedCollection<E>, ? super E> action) {
        this.forEach(element -> action.accept(this, (E)element));
    }

    public void setRandom(WeightedCollectionRandom random) {
        this.random = random;
    }

    public void setRandom(Random random) {
        this.setRandom(random::nextDouble);
    }

    public void setRandom(class_5819 random) {
        this.setRandom(() -> ((class_5819)random).method_43058());
    }

    @Override
    public Stream<E> stream() {
        return this.map.values().stream();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        try {
            return this.map.containsValue(o);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Object @NotNull [] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        return this.map.values().toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("Default add is not supported, use add that takes in a weight.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Removing not supported.");
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException("Default add is not supported, use add that takes in a weight.");
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Removing not supported.");
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Removing not supported.");
    }

    @Override
    public void clear() {
        this.map.clear();
        this.total = 0.0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof WeightedCollection && this.map.equals(((WeightedCollection)o).map);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.total, this.map);
    }

    public static <T> WeightedCollection<T> of(Collection<T> collection, ToDoubleFunction<T> weightGetter) {
        return collection.stream().collect(WeightedCollection.getCollector(weightGetter));
    }

    public static <T> Collector<T, ?, WeightedCollection<T>> getCollector(ToDoubleFunction<T> weightGetter) {
        return Collector.of(WeightedCollection::new, (c, t) -> c.add(weightGetter.applyAsDouble(t), t), (left, right) -> {
            left.forEach(item -> right.add(weightGetter.applyAsDouble(item), item));
            return right;
        }, new Collector.Characteristics[0]);
    }

    @FunctionalInterface
    public static interface WeightedCollectionRandom {
        public double nextDouble();
    }
}

