/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.gui.GuiConfigControl;
import team.creative.creativecore.common.config.gui.GuiConfigSubControl;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.flow.GuiFlow;

public class GuiConfigSubControlHolder
extends GuiConfigSubControl {
    public ICreativeConfigHolder holder;
    public Object value;
    private final Runnable updateListener;

    public GuiConfigSubControlHolder(String name, ICreativeConfigHolder holder, Object value, Runnable updateListener) {
        super(name);
        this.setExpandable();
        this.holder = holder;
        this.value = value;
        this.updateListener = updateListener;
        this.flow = GuiFlow.STACK_Y;
    }

    public void load(ICreativeConfigHolder holder, Object value) {
        this.holder = holder;
        this.value = value;
    }

    public void createControls() {
        for (ConfigKey configKey : this.holder.fields()) {
            Object value;
            if (configKey.requiresRestart || (value = configKey.get()) instanceof ICreativeConfigHolder) continue;
            String path = "config." + String.join((CharSequence)".", this.holder.path());
            if (!path.endsWith(".")) {
                path = path + ".";
            }
            String caption = GuiConfigSubControlHolder.translateOrDefault(path + configKey.name + ".name", configKey.name);
            String comment = path + configKey.name + ".comment";
            GuiConfigControl config = new GuiConfigControl((ConfigKey.ConfigKeyField)configKey, Side.SERVER, caption, comment){

                @Override
                public void updateButton() {
                    super.updateButton();
                    GuiConfigSubControlHolder.this.updateListener.run();
                }
            };
            this.add((GuiControl)config);
            config.init(null);
        }
    }

    public void save() {
        JsonObject json = new JsonObject();
        for (GuiChildControl child : this.controls) {
            JsonElement element;
            if (!(child.control instanceof GuiConfigControl) || (element = ((GuiConfigControl)child.control).save()) == null) continue;
            json.add(((GuiConfigControl)child.control).field.name, element);
        }
        this.holder.load(false, true, json, Side.SERVER);
    }
}

