/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxUtils;
import team.creative.creativecore.common.util.math.collision.CollisionCoordinator;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class ABB {
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;

    public static double min(class_238 bb, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> bb.field_1323;
            case class_2350.class_2351.field_11052 -> bb.field_1322;
            case class_2350.class_2351.field_11051 -> bb.field_1321;
        };
    }

    public static double max(class_238 bb, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> bb.field_1320;
            case class_2350.class_2351.field_11052 -> bb.field_1325;
            case class_2350.class_2351.field_11051 -> bb.field_1324;
        };
    }

    public static double min(class_238 bb, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> bb.field_1323;
            case Axis.Y -> bb.field_1322;
            case Axis.Z -> bb.field_1321;
        };
    }

    public static double max(class_238 bb, Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> bb.field_1320;
            case Axis.Y -> bb.field_1325;
            case Axis.Z -> bb.field_1324;
        };
    }

    public double get(class_238 bb, Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> bb.field_1320;
            case Facing.WEST -> bb.field_1323;
            case Facing.UP -> bb.field_1325;
            case Facing.DOWN -> bb.field_1322;
            case Facing.SOUTH -> bb.field_1324;
            case Facing.NORTH -> bb.field_1321;
        };
    }

    public static ABB createEmptyBox() {
        return new ABB(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    @Nullable
    public static class_3965 clip(Iterable<ABB> boxes, class_243 pos, class_243 look, class_2338 blockPos) {
        class_3965 hit = null;
        double distance = Double.POSITIVE_INFINITY;
        for (ABB box : boxes) {
            double tempDistance;
            class_3965 temp = box.rayTrace(pos, look, blockPos);
            if (temp == null || !((tempDistance = pos.method_1025(temp.method_17784())) < distance)) continue;
            hit = temp;
            distance = tempDistance;
        }
        return hit;
    }

    public ABB(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public ABB(class_238 bb) {
        this(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
    }

    public ABB(ABB bb) {
        this(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
    }

    public double get(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.EAST -> this.maxX;
            case Facing.WEST -> this.minX;
            case Facing.UP -> this.maxY;
            case Facing.DOWN -> this.minY;
            case Facing.SOUTH -> this.maxZ;
            case Facing.NORTH -> this.minZ;
        };
    }

    public double min(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> this.minX;
            case class_2350.class_2351.field_11052 -> this.minY;
            case class_2350.class_2351.field_11051 -> this.minZ;
        };
    }

    public double max(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> this.maxX;
            case class_2350.class_2351.field_11052 -> this.maxY;
            case class_2350.class_2351.field_11051 -> this.maxZ;
        };
    }

    public double min(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.minX;
            case Axis.Y -> this.minY;
            case Axis.Z -> this.minZ;
        };
    }

    public double max(Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> this.maxX;
            case Axis.Y -> this.maxY;
            case Axis.Z -> this.maxZ;
        };
    }

    public Vec3d corner(BoxCorner corner) {
        return new Vec3d(this.cornerX(corner), this.cornerY(corner), this.cornerZ(corner));
    }

    public double cornerValue(class_238 bb, BoxCorner corner, Axis axis) {
        return this.get(corner.getFacing(axis));
    }

    public double cornerX(BoxCorner corner) {
        return this.get(corner.x);
    }

    public double cornerY(BoxCorner corner) {
        return this.get(corner.y);
    }

    public double cornerZ(BoxCorner corner) {
        return this.get(corner.z);
    }

    public boolean intersectsWithAxis(Axis axis, class_238 bb2) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> {
                if (this.minY < bb2.field_1325 && this.maxY > bb2.field_1322 && this.minZ < bb2.field_1324 && this.maxZ > bb2.field_1321) {
                    yield true;
                }
                yield false;
            }
            case Axis.Y -> {
                if (this.minX < bb2.field_1320 && this.maxX > bb2.field_1323 && this.minZ < bb2.field_1324 && this.maxZ > bb2.field_1321) {
                    yield true;
                }
                yield false;
            }
            case Axis.Z -> this.minX < bb2.field_1320 && this.maxX > bb2.field_1323 && this.minY < bb2.field_1325 && this.maxY > bb2.field_1322;
        };
    }

    public boolean intersectsWithAxis(Axis axis, ABB bb2) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> {
                if (this.minY < bb2.maxY && this.maxY > bb2.minY && this.minZ < bb2.maxZ && this.maxZ > bb2.minZ) {
                    yield true;
                }
                yield false;
            }
            case Axis.Y -> {
                if (this.minX < bb2.maxX && this.maxX > bb2.minX && this.minZ < bb2.maxZ && this.maxZ > bb2.minZ) {
                    yield true;
                }
                yield false;
            }
            case Axis.Z -> this.minX < bb2.maxX && this.maxX > bb2.minX && this.minY < bb2.maxY && this.maxY > bb2.minY;
        };
    }

    public boolean intersectsWithAxis(Axis one, Axis two, double valueOne, double valueTwo) {
        return this.min(one) < valueOne && this.max(one) > valueOne && this.min(two) < valueTwo && this.max(two) > valueTwo;
    }

    public double calculateAxisOffset(Axis axis, Axis one, Axis two, class_238 other, double offset) {
        if (this.intersectsWithAxis(axis, other)) {
            double newDistance;
            if (offset > 0.0 && ABB.max(other, axis) <= this.min(axis)) {
                double newDistance2 = this.min(axis) - ABB.max(other, axis);
                if (newDistance2 < offset) {
                    return newDistance2;
                }
            } else if (offset < 0.0 && ABB.min(other, axis) >= this.max(axis) && (newDistance = this.max(axis) - ABB.min(other, axis)) > offset) {
                return newDistance;
            }
        }
        return offset;
    }

    public ABB copy() {
        return new ABB(this);
    }

    public void move(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
    }

    public ABB moveCopy(double x, double y, double z) {
        ABB bb = this.copy();
        bb.move(x, y, z);
        return bb;
    }

    public Vec3d[] getCorners() {
        Vec3d[] corners = new Vec3d[BoxCorner.values().length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = this.corner(BoxCorner.values()[i]);
        }
        return corners;
    }

    public Vec3d[] getRotatedCorners(IVecOrigin origin) {
        Vec3d[] corners = this.getCorners();
        for (int i = 0; i < corners.length; ++i) {
            origin.transformPointToWorld(corners[i]);
        }
        return corners;
    }

    public Vec3d[] getOuterCorner(Facing facing, IVecOrigin origin, double minOne, double minTwo, double maxOne, double maxTwo) {
        Vec3d[] corners = this.getCorners();
        double value = 0.0;
        Enum selected = null;
        Axis axis = facing.axis;
        for (int i = 0; i < corners.length; ++i) {
            Vec3d vec = corners[i];
            origin.transformPointToWorld(vec);
            double vectorValue = vec.get(axis);
            if (selected != null && !(facing.positive ? vectorValue > value : vectorValue < value)) continue;
            selected = BoxCorner.values()[i];
            value = vectorValue;
        }
        return new Vec3d[]{corners[selected.ordinal()], corners[((BoxCorner)selected).neighborOne.ordinal()], corners[((BoxCorner)selected).neighborTwo.ordinal()], corners[((BoxCorner)selected).neighborThree.ordinal()]};
    }

    public void include(Vec3d vec) {
        this.minX = Math.min(this.minX, vec.x);
        this.minY = Math.min(this.minY, vec.y);
        this.minZ = Math.min(this.minZ, vec.z);
        this.maxX = Math.max(this.maxX, vec.x);
        this.maxY = Math.max(this.maxY, vec.y);
        this.maxZ = Math.max(this.maxZ, vec.z);
    }

    public void include(Facing facing, double value) {
        switch (facing) {
            case EAST: {
                this.maxX = Math.max(this.maxX, value);
                break;
            }
            case WEST: {
                this.minX = Math.min(this.minX, value);
                break;
            }
            case UP: {
                this.maxY = Math.max(this.maxY, value);
                break;
            }
            case DOWN: {
                this.minY = Math.min(this.minY, value);
                break;
            }
            case SOUTH: {
                this.maxZ = Math.max(this.maxZ, value);
                break;
            }
            case NORTH: {
                this.minZ = Math.min(this.minZ, value);
            }
        }
    }

    public class_238 toVanilla() {
        return new class_238(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public class_3965 rayTrace(class_243 pos, class_243 look, class_2338 blockPos) {
        double[] time = new double[]{1.0};
        double x = look.field_1352 - pos.field_1352;
        double y = look.field_1351 - pos.field_1351;
        double z = look.field_1350 - pos.field_1350;
        Facing facing = this.clipFacing(pos, time, null, x, y, z, blockPos);
        if (facing == null) {
            return null;
        }
        return new class_3965(pos.method_1031(x * time[0], y * time[0], z * time[0]), facing.toVanilla(), blockPos, false);
    }

    private Facing clipFacing(class_243 pos, double[] time, Facing facing, double x, double y, double z, class_2338 blockPos) {
        for (int i = 0; i < Facing.VALUES.length; ++i) {
            Facing toClip = Facing.VALUES[i];
            if (!(toClip.positive ? toClip.axis.get(x, y, z) < 1.0E-7 : toClip.axis.get(x, y, z) > 1.0E-7)) continue;
            facing = this.clipPoint(time, facing, toClip, x, y, z, pos, blockPos);
        }
        return facing;
    }

    private Facing clipPoint(double[] time, Facing original, Facing toClip, double x, double y, double z, class_243 pos, class_2338 blockPos) {
        double d0 = (this.get(toClip) + (double)blockPos.method_30558(toClip.axis.toVanilla()) - pos.method_18043(toClip.axis.toVanilla())) / toClip.axis.get(x, y, z);
        double d1 = pos.method_18043(toClip.one().toVanilla()) + d0 * toClip.one().get(x, y, z);
        double d2 = pos.method_18043(toClip.two().toVanilla()) + d0 * toClip.two().get(x, y, z);
        if (0.0 < d0 && d0 < time[0] && this.min(toClip.one()) + (double)blockPos.method_30558(toClip.one().toVanilla()) - 1.0E-7 < d1 && d1 < this.max(toClip.one()) + (double)blockPos.method_30558(toClip.one().toVanilla()) + 1.0E-7 && this.min(toClip.two()) + (double)blockPos.method_30558(toClip.two().toVanilla()) - 1.0E-7 < d2 && d2 < this.max(toClip.two()) + (double)blockPos.method_30558(toClip.two().toVanilla()) + 1.0E-7) {
            time[0] = d0;
            return toClip;
        }
        return original;
    }

    public ABB createRotatedSurrounding(CollisionCoordinator coordinator) {
        Vec3d[] corners = this.getRotatedCorners(coordinator.original());
        ABB bb = ABB.createEmptyBox();
        for (int i = 0; i < corners.length; ++i) {
            Vec3d vec = corners[i];
            bb.include(vec);
            if (coordinator.hasOnlyTranslation()) {
                vec.add(coordinator.translation);
                bb.include(vec);
                continue;
            }
            BoxUtils.includeMaxRotationInBox(bb, new Vec3d(vec), Axis.X, coordinator);
            BoxUtils.includeMaxRotationInBox(bb, new Vec3d(vec), Axis.Y, coordinator);
            BoxUtils.includeMaxRotationInBox(bb, new Vec3d(vec), Axis.Z, coordinator);
            coordinator.transform(vec, 1.0);
            bb.include(vec);
        }
        return bb;
    }

    public ABB createRotatedSurroundingInverseInternal(CollisionCoordinator coordinator) {
        Vec3d[] corners = this.getCorners();
        ABB bb = ABB.createEmptyBox();
        for (int i = 0; i < corners.length; ++i) {
            Vec3d vec = corners[i];
            bb.include(vec);
            if (coordinator.hasOnlyTranslation()) {
                vec.sub(coordinator.translation);
                bb.include(vec);
                continue;
            }
            BoxUtils.includeMaxRotationInBoxInverse(bb, new Vec3d(vec), Axis.X, coordinator);
            BoxUtils.includeMaxRotationInBoxInverse(bb, new Vec3d(vec), Axis.Y, coordinator);
            BoxUtils.includeMaxRotationInBoxInverse(bb, new Vec3d(vec), Axis.Z, coordinator);
            coordinator.transformInverted(vec, 1.0);
            bb.include(vec);
        }
        return bb;
    }

    public boolean contains(Vec3d vec) {
        return this.contains(vec.x, vec.y, vec.z);
    }

    public boolean contains(class_243 vec) {
        return this.contains(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public boolean intersectsPrecise(class_238 bb) {
        return this.intersects(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
    }

    public boolean intersects(class_238 bb) {
        return this.intersects(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
    }

    public boolean intersects(ABB bb) {
        return this.intersects(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
    }

    public boolean intersects(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.minX < maxX && this.maxX > minX && this.minY < maxY && this.maxY > minY && this.minZ < maxZ && this.maxZ > minZ;
    }

    public boolean intersects(class_243 vec1, class_243 vec2) {
        return this.intersects(Math.min(vec1.field_1352, vec2.field_1352), Math.min(vec1.field_1351, vec2.field_1351), Math.min(vec1.field_1350, vec2.field_1350), Math.max(vec1.field_1352, vec2.field_1352), Math.max(vec1.field_1351, vec2.field_1351), Math.max(vec1.field_1350, vec2.field_1350));
    }

    public boolean contains(double x, double y, double z) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY && z >= this.minZ && z < this.maxZ;
    }

    public class_243 getCenter() {
        return new class_243(class_3532.method_16436((double)0.5, (double)this.minX, (double)this.maxX), class_3532.method_16436((double)0.5, (double)this.minY, (double)this.maxY), class_3532.method_16436((double)0.5, (double)this.minZ, (double)this.maxZ));
    }

    public String toString() {
        return "ABB[" + this.minX + ", " + this.minY + ", " + this.minZ + "] -> [" + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }
}

