/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.network.AbstractPacket;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.network.SerializableDataTicket;
import software.bernie.geckolib.util.ClientUtils;

public class BlockEntityAnimDataSyncPacket<D>
extends AbstractPacket {
    private final class_2338 BLOCK_POS;
    private final SerializableDataTicket<D> DATA_TICKET;
    private final D DATA;

    public BlockEntityAnimDataSyncPacket(class_2338 pos, SerializableDataTicket<D> dataTicket, D data) {
        this.BLOCK_POS = pos;
        this.DATA_TICKET = dataTicket;
        this.DATA = data;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(this.BLOCK_POS);
        buf.method_10814(this.DATA_TICKET.id());
        this.DATA_TICKET.encode(this.DATA, buf);
        return buf;
    }

    @Override
    public class_2960 getPacketID() {
        return GeckoLibNetwork.BLOCK_ENTITY_ANIM_DATA_SYNC_PACKET_ID;
    }

    public static <D> void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_2338 BLOCK_POS = buf.method_10811();
        SerializableDataTicket<?> DATA_TICKET = DataTickets.byName(buf.method_19772());
        Object DATA = DATA_TICKET.decode(buf);
        client.execute(() -> BlockEntityAnimDataSyncPacket.runOnThread(BLOCK_POS, DATA_TICKET, DATA));
    }

    private static <D> void runOnThread(class_2338 blockPos, SerializableDataTicket<D> dataTicket, D data) {
        class_2586 blockEntity = ClientUtils.getLevel().method_8321(blockPos);
        if (blockEntity instanceof GeoBlockEntity) {
            GeoBlockEntity geoBlockEntity = (GeoBlockEntity)blockEntity;
            geoBlockEntity.setAnimData(dataTicket, data);
        }
    }
}

