/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.network.AbstractPacket;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.RenderUtils;

public class EntityAnimTriggerPacket
extends AbstractPacket {
    private final int ENTITY_ID;
    private final boolean IS_REPLACED_ENTITY;
    private final String CONTROLLER_NAME;
    private final String ANIM_NAME;

    public EntityAnimTriggerPacket(int entityId, @Nullable String controllerName, String animName) {
        this(entityId, false, controllerName, animName);
    }

    public EntityAnimTriggerPacket(int entityId, boolean isReplacedEntity, @Nullable String controllerName, String animName) {
        this.ENTITY_ID = entityId;
        this.IS_REPLACED_ENTITY = isReplacedEntity;
        this.CONTROLLER_NAME = controllerName == null ? "" : controllerName;
        this.ANIM_NAME = animName;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(this.ENTITY_ID);
        buf.method_52964(this.IS_REPLACED_ENTITY);
        buf.method_10814(this.CONTROLLER_NAME);
        buf.method_10814(this.ANIM_NAME);
        return buf;
    }

    @Override
    public class_2960 getPacketID() {
        return GeckoLibNetwork.ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID;
    }

    public static void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int ENTITY_ID = buf.method_10816();
        boolean IS_REPLACED_ENTITY = buf.readBoolean();
        String CONTROLLER_NAME = buf.method_19772();
        String ANIM_NAME = buf.method_19772();
        client.execute(() -> EntityAnimTriggerPacket.runOnThread(ENTITY_ID, IS_REPLACED_ENTITY, CONTROLLER_NAME, ANIM_NAME));
    }

    private static void runOnThread(int entityId, boolean isReplacedEntity, String controllerName, String animName) {
        class_1297 entity = ClientUtils.getLevel().method_8469(entityId);
        if (entity == null) {
            return;
        }
        if (!isReplacedEntity) {
            if (entity instanceof GeoEntity) {
                GeoEntity geoEntity = (GeoEntity)entity;
                geoEntity.triggerAnim(controllerName.isEmpty() ? null : controllerName, animName);
            }
            return;
        }
        GeoAnimatable animatable = RenderUtils.getReplacedAnimatable(entity.method_5864());
        if (animatable instanceof GeoReplacedEntity) {
            GeoReplacedEntity replacedEntity = (GeoReplacedEntity)animatable;
            replacedEntity.triggerAnim(entity, controllerName.isEmpty() ? null : controllerName, animName);
        }
    }
}

