/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ModConfig;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8610;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLib
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"configlib");
    protected static final class_2960 CHANNEL_ID = new class_2960("supermartijn642configlib", "sync_configs");
    private static final List<ModConfig<?>> CONFIGS = new ArrayList();
    private static final Set<String> CONFIG_NAMES = new HashSet<String>();
    private static final List<ModConfig<?>> SYNCABLE_CONFIGS = new ArrayList();
    private static final Map<String, ModConfig<?>> SYNCABLE_CONFIGS_BY_IDENTIFIER = new HashMap();

    public ConfigLib() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ConfigLib.onLoadGame());
        ServerConfigurationConnectionEvents.CONFIGURE.register(ConfigLib::onPlayerJoinServer);
    }

    public void onInitialize() {
    }

    public static boolean isClientEnvironment() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isServerEnvironment() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public static File getConfigFolder() {
        return FabricLoader.getInstance().getConfigDir().toFile();
    }

    protected static synchronized void addConfig(ModConfig<?> config) {
        if (CONFIG_NAMES.contains(config.getIdentifier())) {
            throw new IllegalStateException("Config '" + config.getIdentifier() + "' for mod '" + config.getModid() + "' already exists!");
        }
        CONFIGS.add(config);
        CONFIG_NAMES.add(config.getIdentifier());
        if (config.hasSyncableEntries()) {
            SYNCABLE_CONFIGS.add(config);
            SYNCABLE_CONFIGS_BY_IDENTIFIER.put(config.getIdentifier(), config);
        }
        config.initialize();
    }

    protected static void onLoadGame() {
        CONFIGS.forEach(ModConfig::onJoinGame);
    }

    protected static void onLeaveGame() {
        CONFIGS.forEach(ModConfig::onLeaveGame);
    }

    protected static void onPlayerJoinServer(class_8610 handler, MinecraftServer server) {
        ConfigLib.sendSyncConfigPackets(handler);
    }

    private static void sendSyncConfigPackets(class_8610 handler) {
        for (ModConfig<?> config : SYNCABLE_CONFIGS) {
            class_2540 buffer = ConfigLib.createSyncedEntriesPacket(config);
            if (buffer == null) continue;
            ServerConfigurationNetworking.send((class_8610)handler, (class_2960)CHANNEL_ID, (class_2540)buffer);
        }
    }

    private static class_2540 createSyncedEntriesPacket(ModConfig<?> config) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.method_10814(config.getIdentifier());
        try {
            config.writeSyncableEntries((ByteBuf)buffer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", (Throwable)e);
            buffer.release();
            return null;
        }
        return buffer;
    }

    protected static void handleSyncConfigPacket(class_2540 buffer) {
        String identifier = buffer.method_19772();
        ModConfig<?> config = SYNCABLE_CONFIGS_BY_IDENTIFIER.get(identifier);
        if (config == null) {
            LOGGER.error("Received config sync packet for unknown config '" + identifier + "'!");
            return;
        }
        try {
            config.readSyncableValues((ByteBuf)buffer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", (Throwable)e);
        }
    }
}

