/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.enumerations;

import io.github.thecsdev.betterstats.api.util.BSUtils;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProvider;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfo;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfoProvider;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public enum FilterGroupBy implements ITextProvider
{
    DEFAULT((class_2561)BST.filter_groupBy_default()),
    ALL((class_2561)TextUtils.translatable((String)"gui.all", (Object[])new Object[0])),
    MOD((class_2561)BST.filter_groupBy_mod());

    private final class_2561 text;

    private FilterGroupBy(class_2561 text) {
        this.text = Objects.requireNonNull(text);
    }

    public final class_2561 getText() {
        return this.text;
    }

    @SafeVarargs
    public final <S extends SUStat<?>> Map<class_2561, List<S>> apply(Iterable<S> stats, S ... typeClassGetter) throws NullPointerException {
        Objects.requireNonNull(stats);
        Objects.requireNonNull(typeClassGetter);
        if (!stats.iterator().hasNext()) {
            return new HashMap<class_2561, List<S>>();
        }
        switch (this.ordinal()) {
            case 1: {
                return FilterGroupBy.apply_all(stats);
            }
            case 2: {
                return FilterGroupBy.apply_mod(stats);
            }
        }
        Class<?> type = Objects.requireNonNull(typeClassGetter.getClass().getComponentType());
        if (type.equals(SUItemStat.class)) {
            Iterable<SUItemStat> statsI = stats;
            return FilterGroupBy.apply_itemGroups(statsI);
        }
        return FilterGroupBy.apply_mod(stats);
    }

    private static final <S extends SUStat<?>> Map<class_2561, List<S>> apply_all(Iterable<S> stats) {
        HashMap<class_2561, List<S>> map = new HashMap<class_2561, List<S>>();
        ArrayList<S> list = new ArrayList<S>(StreamSupport.stream(stats.spliterator(), false).toList());
        map.put((class_2561)TextUtils.literal((String)"*"), (List<S>)list);
        return map;
    }

    private static final <S extends SUStat<?>> Map<class_2561, List<S>> apply_mod(Iterable<S> stats) {
        ModInfoProvider mip = Objects.requireNonNull(ModInfoProvider.getInstance());
        LinkedHashMap map = new LinkedHashMap();
        StreamSupport.stream(stats.spliterator(), false).forEach(stat -> {
            String groupName = stat.getStatID().method_12836();
            LinkedList<SUStat> group = (LinkedList<SUStat>)map.get(groupName);
            if (group == null) {
                group = new LinkedList<SUStat>();
                map.put(groupName, group);
            }
            group.add((SUStat)stat);
        });
        return map.entrySet().stream().map(mapEntry -> {
            @Nullable ModInfo modInfo = mip.getModInfo((String)mapEntry.getKey());
            class_2561 newKey = modInfo != null ? modInfo.getName() : TextUtils.literal((String)((String)mapEntry.getKey()));
            return new AbstractMap.SimpleEntry<class_2561, List>(newKey, (List)mapEntry.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, LinkedHashMap::new));
    }

    private static final <S extends SUStat<?>> Map<class_2561, List<S>> apply_itemGroups(Iterable<SUItemStat> stats) {
        LinkedHashMap map = new LinkedHashMap();
        map.put(null, new LinkedList());
        stats.forEach(stat -> {
            class_1761 itemGroup = BSUtils.getItemGroup(stat.getItem());
            LinkedList<SUItemStat> group = (LinkedList<SUItemStat>)map.get(itemGroup);
            if (group == null) {
                group = new LinkedList<SUItemStat>();
                map.put(itemGroup, group);
            }
            group.add((SUItemStat)stat);
        });
        map.entrySet().removeIf(e -> ((List)e.getValue()).size() == 0);
        return map.entrySet().stream().map(mapEntry -> {
            class_5250 name = mapEntry.getKey() != null ? ((class_1761)mapEntry.getKey()).method_7737() : TextUtils.literal((String)"*");
            return new AbstractMap.SimpleEntry<class_5250, List>(name, (List)mapEntry.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, LinkedHashMap::new));
    }
}

