/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.panel;

import io.github.thecsdev.betterstats.BetterStatsProperties;
import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.gui.screen.BetterStatsScreen;
import io.github.thecsdev.betterstats.api.client.registry.BSClientRegistries;
import io.github.thecsdev.betterstats.api.client.registry.BSStatsTabs;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.events.client.gui.BetterStatsGUIEvent;
import io.github.thecsdev.betterstats.api.util.io.IEditableStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.screen.hud.BetterStatsHudScreen;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.TCDCommonsConfig;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.menu.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.menu.TMenuBarPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TStackTraceScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.TFileChooserResult;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.TFileChooserScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_447;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_7919;

public final class MenuBarPanel
extends BSComponentPanel {
    public static final int HEIGHT = 15;
    private final MenuBarPanelProxy proxy;

    public MenuBarPanel(int x, int y, int width, MenuBarPanelProxy proxy) throws NullPointerException {
        super(x, y, width, 15);
        this.proxy = Objects.requireNonNull(proxy);
    }

    public final void setSize(int width, int height, int flags) {
        super.setSize(width, height, flags);
        if (this.getParentTScreen() != null && (flags & 8) == 8) {
            this.refresh();
        }
    }

    public final MenuBarPanelProxy getProxy() {
        return this.proxy;
    }

    protected final void init() {
        class_2561 displayName;
        class_746 localPlayer = BetterStatsClient.MC_CLIENT.field_1724;
        TMenuBarPanel menu = new TMenuBarPanel(0, 0, this.getWidth());
        menu.setBackgroundColor(0);
        menu.setOutlineColor(0);
        menu.addButton((class_2561)BST.menu_file(), btn -> {
            TContextMenuPanel cMenu = new TContextMenuPanel((TElement)btn);
            cMenu.addButton((class_2561)BST.menu_file_open(), __ -> TFileChooserScreen.showOpenFileDialog((String)"mcbs", result -> {
                if (result.getReturnValue() != TFileChooserResult.ReturnValue.APPROVE_OPTION) {
                    return;
                }
                try {
                    IEditableStatsProvider stats = StatsProviderIO.loadFromFile(result.getSelectedFile());
                    class_437 parentScreen = GuiUtils.getCurrentScreenParent();
                    BetterStatsClient.MC_CLIENT.method_1507(new BetterStatsScreen(parentScreen, stats).getAsScreen());
                }
                catch (Exception exc) {
                    BetterStatsClient.MC_CLIENT.method_1507(new TStackTraceScreen(BetterStatsClient.MC_CLIENT.field_1755, (Throwable)exc).getAsScreen());
                }
            }));
            cMenu.addButton((class_2561)BST.menu_file_saveAs(), __ -> TFileChooserScreen.showSaveFileDialog((String)"mcbs", result -> {
                if (result.getReturnValue() != TFileChooserResult.ReturnValue.APPROVE_OPTION) {
                    return;
                }
                try {
                    File file = result.getSelectedFile();
                    IStatsProvider stats = this.proxy.getStatsProvider();
                    StatsProviderIO.saveToFile(file, stats);
                }
                catch (Exception exc) {
                    BetterStatsClient.MC_CLIENT.method_1507(new TStackTraceScreen(BetterStatsClient.MC_CLIENT.field_1755, (Throwable)exc).getAsScreen());
                }
            }));
            cMenu.open();
        });
        menu.addButton((class_2561)BST.menu_view(), btn -> {
            TContextMenuPanel cMenu = new TContextMenuPanel((TElement)btn);
            cMenu.addButton((class_2561)BST.menu_view_vStats(), __ -> {
                if (localPlayer == null) {
                    return;
                }
                BetterStatsClient.MC_CLIENT.method_1507((class_437)new class_447(BetterStatsClient.MC_CLIENT.field_1755, localPlayer.method_3143()));
            });
            cMenu.addButton(BetterStatsHudScreen.TEXT_TITLE, __ -> {
                BetterStatsHudScreen sc = BetterStatsHudScreen.getInstance();
                sc.setParentScreen(BetterStatsClient.MC_CLIENT.field_1755);
                BetterStatsClient.MC_CLIENT.method_1507(sc.getAsScreen());
            });
            cMenu.addSeparator();
            for (Map.Entry statsTabEntry : BSClientRegistries.STATS_TAB) {
                StatsTab statsTab = (StatsTab)statsTabEntry.getValue();
                if (!statsTab.isAvailable()) continue;
                cMenu.addButton(statsTab.getName(), __ -> this.proxy.setSelectedStatsTab(statsTab));
            }
            cMenu.addSeparator();
            cMenu.addButton((class_2561)TextUtils.translatable((String)"options.title", (Object[])new Object[0]), __ -> this.proxy.setSelectedStatsTab(BSStatsTabs.BSS_CONFIG));
            cMenu.addButton((class_2561)TextUtils.translatable((String)"credits_and_attribution.button.credits", (Object[])new Object[0]), __ -> this.proxy.setSelectedStatsTab(BSStatsTabs.BSS_CREDITS));
            cMenu.open();
        });
        menu.addButton((class_2561)BST.menu_about(), btn -> {
            TContextMenuPanel cMenu = new TContextMenuPanel((TElement)btn);
            cMenu.addButton((class_2561)BST.menu_about_src(), __ -> GuiUtils.showUrlPrompt((String)BetterStatsProperties.URL_SOURCES, (boolean)true));
            cMenu.addButton((class_2561)TextUtils.translatable((String)"menu.reportBugs", (Object[])new Object[0]), __ -> GuiUtils.showUrlPrompt((String)BetterStatsProperties.URL_ISSUES, (boolean)true));
            cMenu.addSeparator();
            cMenu.addButton((class_2561)BST.menu_about_cf(), __ -> GuiUtils.showUrlPrompt((String)BetterStatsProperties.URL_CURSEFORGE, (boolean)true));
            cMenu.addButton((class_2561)BST.menu_about_mr(), __ -> GuiUtils.showUrlPrompt((String)BetterStatsProperties.URL_MODRINTH, (boolean)true));
            if (!TCDCommonsConfig.RESTRICTED_MODE) {
                cMenu.addSeparator();
                cMenu.addButton((class_2561)BST.menu_about_website(), __ -> GuiUtils.showUrlPrompt((String)BetterStatsProperties.URL_WEBSITE, (boolean)true));
                cMenu.addButton((class_2561)BST.menu_about_yt(), __ -> GuiUtils.showUrlPrompt((String)BetterStatsProperties.URL_YOUTUBE, (boolean)true));
            }
            cMenu.addSeparator();
            cMenu.addButton((class_2561)TextUtils.translatable((String)"credits_and_attribution.button.credits", (Object[])new Object[0]), __ -> this.proxy.setSelectedStatsTab(BSStatsTabs.BSS_CREDITS));
            cMenu.open();
        });
        menu.addButton(BSStatsTabs.BSS_STATS_SHARING.getName(), btn -> this.proxy.setSelectedStatsTab(BSStatsTabs.BSS_STATS_SHARING)).setTooltip(class_7919.method_47407((class_2561)TextUtils.literal((String)"").method_10852((class_2561)BST.gui_tpsbs()).method_27693("\n").method_10852((class_2561)BST.gui_tpsbs_description().method_27692(class_124.field_1080))));
        ((BetterStatsGUIEvent.MenuBarInitialized)BetterStatsGUIEvent.MENU_BAR_INITIALIZED.invoker()).invoke(menu);
        this.addChild((TElement)menu, true);
        IStatsProvider statsProvider = this.proxy.getStatsProvider();
        boolean isESP = statsProvider instanceof IEditableStatsProvider;
        class_2561 class_25612 = displayName = statsProvider != null ? statsProvider.getDisplayName() : null;
        if (displayName == null) {
            displayName = TextUtils.literal((String)"-");
        }
        int displayNameW = this.getTextRenderer().method_27525((class_5348)displayName);
        int menuSP = menu.getScrollPadding();
        int n = menu.getEndX();
        Objects.requireNonNull(this.getTextRenderer());
        TLabelElement lbl_displayName = new TLabelElement(n - (menuSP + displayNameW + 9), menu.getY() + menuSP, displayNameW, menu.getHeight() - menuSP * 2, displayName);
        lbl_displayName.setTextColor(isESP ? -1 : -256);
        this.addChild((TElement)lbl_displayName, false);
    }

    public static interface MenuBarPanelProxy {
        public IStatsProvider getStatsProvider();

        public void setSelectedStatsTab(StatsTab var1);
    }
}

