/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.api.util.interfaces.IThirdPartyStatsListener;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.io.StatsProviderIO;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.network.OtherClientPlayerStatsProvider;
import io.github.thecsdev.betterstats.network.BetterStatsNetwork;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenWrapper;
import io.github.thecsdev.tcdcommons.api.events.client.MinecraftClientEvent;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.github.thecsdev.tcdcommons.api.util.collections.GenericProperties;
import io.github.thecsdev.tcdcommons.api.util.thread.TaskScheduler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_4093;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BetterStatsClientPlayNetworkHandler {
    public static final class_2960 CUSTOM_DATA_ID = new class_2960(BetterStats.getModID(), "client_play_network_handler");
    private final class_746 player;
    private final BetterStatsConfig config;
    public boolean serverHasBss = false;
    public boolean bssNetworkConsent = false;
    public boolean netPref_enableLiveStats = false;
    private final Cache<String, OtherClientPlayerStatsProvider> sessionPlayerStatStorage;

    private BetterStatsClientPlayNetworkHandler(class_746 player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
        this.config = Objects.requireNonNull(BetterStats.getInstance().getConfig());
        this.sessionPlayerStatStorage = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        TaskScheduler.schedulePeriodicCacheCleanup(this.sessionPlayerStatStorage);
        AtomicReference<Object> evhCd = new AtomicReference<Object>(null);
        evhCd.set(((MinecraftClientEvent.ClientDisconnect)client -> {
            MinecraftClientEvent.DISCONNECTED.unregister((Object)Objects.requireNonNull((MinecraftClientEvent.ClientDisconnect)evhCd.get()));
            this.onDisconnected();
        }));
        MinecraftClientEvent.DISCONNECTED.register((Object)Objects.requireNonNull(evhCd.get()));
    }

    public final class_746 getPlayer() {
        return this.player;
    }

    public final OtherClientPlayerStatsProvider getSessionPlayerStats(String otherPlayerName) throws NullPointerException {
        Objects.requireNonNull(otherPlayerName);
        OtherClientPlayerStatsProvider stats = (OtherClientPlayerStatsProvider)this.sessionPlayerStatStorage.getIfPresent((Object)otherPlayerName);
        if (stats == null) {
            stats = new OtherClientPlayerStatsProvider(otherPlayerName);
            this.sessionPlayerStatStorage.put((Object)otherPlayerName, (Object)stats);
        }
        return stats;
    }

    public final void onDisconnected() {
        this.serverHasBss = false;
        this.netPref_enableLiveStats = false;
        this.bssNetworkConsent = false;
        this.sessionPlayerStatStorage.invalidateAll();
    }

    public final void onIHaveBss(CustomPayloadNetworkReceiver.PacketContext ctx) {
        if (this.serverHasBss) {
            return;
        }
        class_2540 buffer = ctx.getPacketBuffer();
        if (buffer.readableBytes() == 0) {
            return;
        }
        int netVer = buffer.readIntLE();
        if (netVer != 3) {
            return;
        }
        this.serverHasBss = true;
        BetterStats.LOGGER.info("[Client] The server has '" + BetterStats.getModID() + "' installed.");
        if (BetterStatsClient.MC_CLIENT.method_1542() || BetterStats.getInstance().getConfig().trustAllServersBssNet) {
            TaskScheduler.executeOnce((class_4093)BetterStatsClient.MC_CLIENT, () -> this.player.field_3944 != null, () -> {
                this.sendIHaveBss(true);
                this.sendPreferences();
            });
        }
    }

    public final void onMcbs(CustomPayloadNetworkReceiver.PacketContext ctx) {
        class_2540 buffer = ctx.getPacketBuffer();
        Supplier<@Nullable IThirdPartyStatsListener> listenerSupplier = () -> {
            @Nullable IThirdPartyStatsListener listener = null;
            class_437 patt0$temp = BetterStatsClient.MC_CLIENT.field_1755;
            if (patt0$temp instanceof IThirdPartyStatsListener) {
                IThirdPartyStatsListener l;
                listener = l = (IThirdPartyStatsListener)patt0$temp;
            } else {
                TScreenWrapper tsw;
                TScreen patt2$temp;
                class_437 patt1$temp = BetterStatsClient.MC_CLIENT.field_1755;
                if (patt1$temp instanceof TScreenWrapper && (patt2$temp = (tsw = (TScreenWrapper)patt1$temp).getTargetTScreen()) instanceof IThirdPartyStatsListener) {
                    IThirdPartyStatsListener l;
                    listener = l = (IThirdPartyStatsListener)patt2$temp;
                }
            }
            return listener;
        };
        switch (IThirdPartyStatsListener.TpslContext.Type.of(buffer.readInt())) {
            case NULL: {
                BetterStatsClient.MC_CLIENT.method_40000(() -> {
                    @Nullable IThirdPartyStatsListener listener = (IThirdPartyStatsListener)listenerSupplier.get();
                    if (listener != null) {
                        listener.onStatsReady(new IThirdPartyStatsListener.TpslContext(){

                            @Override
                            public IThirdPartyStatsListener.TpslContext.Type getType() {
                                return IThirdPartyStatsListener.TpslContext.Type.NULL;
                            }

                            @Override
                            public String getPlayerName() {
                                return null;
                            }

                            @Override
                            public IStatsProvider getStatsProvider() {
                                return null;
                            }
                        });
                    }
                });
                break;
            }
            case SAME_SERVER_PLAYER: {
                final String playerName = buffer.method_19772();
                OtherClientPlayerStatsProvider tempStatsProvider = new OtherClientPlayerStatsProvider(playerName);
                try {
                    StatsProviderIO.read(buffer, tempStatsProvider);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                final OtherClientPlayerStatsProvider spss = this.getSessionPlayerStats(playerName);
                spss.setAll(tempStatsProvider);
                BetterStatsClient.MC_CLIENT.method_40000(() -> {
                    @Nullable IThirdPartyStatsListener listener = (IThirdPartyStatsListener)listenerSupplier.get();
                    if (listener != null) {
                        listener.onStatsReady(new IThirdPartyStatsListener.TpslContext(){

                            @Override
                            public IThirdPartyStatsListener.TpslContext.Type getType() {
                                return IThirdPartyStatsListener.TpslContext.Type.SAME_SERVER_PLAYER;
                            }

                            @Override
                            public String getPlayerName() {
                                return playerName;
                            }

                            @Override
                            public IStatsProvider getStatsProvider() {
                                return spss;
                            }
                        });
                    }
                });
                break;
            }
            case SAME_SERVER_PLAYER_NOT_FOUND: {
                final String playerName = buffer.method_19772();
                BetterStatsClient.MC_CLIENT.method_40000(() -> {
                    @Nullable IThirdPartyStatsListener listener = (IThirdPartyStatsListener)listenerSupplier.get();
                    if (listener != null) {
                        listener.onStatsReady(new IThirdPartyStatsListener.TpslContext(){

                            @Override
                            public IThirdPartyStatsListener.TpslContext.Type getType() {
                                return IThirdPartyStatsListener.TpslContext.Type.SAME_SERVER_PLAYER_NOT_FOUND;
                            }

                            @Override
                            public String getPlayerName() {
                                return playerName;
                            }

                            @Override
                            @Nullable
                            public IStatsProvider getStatsProvider() {
                                return null;
                            }
                        });
                    }
                });
                break;
            }
        }
    }

    public final boolean comms() {
        return BetterStatsClient.MC_CLIENT.method_1542() || this.serverHasBss && this.bssNetworkConsent;
    }

    public final boolean sendIHaveBss(boolean forceSend) {
        if (!forceSend && !this.comms()) {
            return false;
        }
        this.bssNetworkConsent = true;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_53003(3);
        CustomPayloadNetwork.sendC2S((class_2960)BetterStatsNetwork.C2S_I_HAVE_BSS, (ByteBuf)data);
        return true;
    }

    public final boolean sendPreferences() {
        if (!this.comms()) {
            return false;
        }
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_52964(this.netPref_enableLiveStats);
        data.method_52964(this.config.netPref_allowStatsSharing);
        CustomPayloadNetwork.sendC2S((class_2960)BetterStatsNetwork.C2S_PREFERENCES, (ByteBuf)data);
        return true;
    }

    public final boolean sendAndRevokePreferences() {
        if (!this.comms()) {
            return false;
        }
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_52964(false);
        data.method_52964(false);
        CustomPayloadNetwork.sendC2S((class_2960)BetterStatsNetwork.C2S_PREFERENCES, (ByteBuf)data);
        this.netPref_enableLiveStats = false;
        this.bssNetworkConsent = false;
        return true;
    }

    public final boolean sendMcbsRequest(String playerName) {
        Objects.requireNonNull(playerName);
        if (!this.comms()) {
            return false;
        }
        class_2540 data = new class_2540(Unpooled.buffer());
        data.method_53002(IThirdPartyStatsListener.TpslContext.Type.SAME_SERVER_PLAYER.getIntValue());
        data.method_10814(playerName);
        CustomPayloadNetwork.sendC2S((class_2960)BetterStatsNetwork.C2S_MCBS_REQUEST, (ByteBuf)data);
        return true;
    }

    public static final BetterStatsClientPlayNetworkHandler of(class_746 player) throws NullPointerException {
        GenericProperties cd = EntityHooks.getCustomData((class_1297)((class_1297)Objects.requireNonNull(player)));
        @Nullable BetterStatsClientPlayNetworkHandler cpnh = (BetterStatsClientPlayNetworkHandler)cd.getProperty((Object)CUSTOM_DATA_ID);
        if (cpnh == null) {
            cpnh = new BetterStatsClientPlayNetworkHandler(player);
            cd.setProperty((Object)CUSTOM_DATA_ID, (Object[])new BetterStatsClientPlayNetworkHandler[]{cpnh});
        }
        return cpnh;
    }

    @Nullable
    public static final BetterStatsClientPlayNetworkHandler getInstance() {
        class_746 player = BetterStatsClient.MC_CLIENT.field_1724;
        class_634 network = BetterStatsClient.MC_CLIENT.method_1562();
        if (player == null || network == null) {
            return null;
        }
        return BetterStatsClientPlayNetworkHandler.of(player);
    }
}

