/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.sound.ISound;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class Sound
implements ISound {
    public static Codec<Sound> CODEC_SIMPLE = class_7923.field_41172.method_39673().xmap(Sound::new, Sound::getSound);
    public static Codec<Sound> CODEC_OBJECT = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41172.method_39673().fieldOf("sound").forGetter(Sound::getSound), BookshelfCodecs.SOUND_SOURCE.get("category", Sound::getCategory, class_3419.field_15250), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(Sound::getPitch), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(Sound::getVolume)).apply((Applicative)instance, Sound::new));
    public static Codec<Sound> CODEC = class_5699.method_53702(CODEC_SIMPLE, CODEC_OBJECT).xmap(either -> (Sound)either.map(Function.identity(), Function.identity()), value -> value.isSimple() ? Either.left((Object)value) : Either.right((Object)value));
    private final class_3414 sound;
    private final class_3419 category;
    private final float pitch;
    private final float volume;

    public Sound(class_3414 sound) {
        this(sound, class_3419.field_15250, 1.0f, 1.0f);
    }

    public Sound(class_3414 sound, class_3419 category, float pitch, float volume) {
        this.sound = sound;
        this.category = category;
        this.pitch = pitch;
        this.volume = volume;
    }

    private boolean isSimple() {
        return this.category == class_3419.field_15250 && this.pitch == 1.0f && this.volume == 1.0f;
    }

    @Override
    public void playSoundAt(class_1937 level, @Nullable class_1657 originator, double posX, double posY, double posZ) {
        level.method_43128(originator, posX, posY, posZ, this.sound, this.category, this.volume, this.pitch);
    }

    public class_3414 getSound() {
        return this.sound;
    }

    public class_3419 getCategory() {
        return this.category;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    public String toString() {
        return "Sound{sound=" + this.sound.method_14833() + ", category=" + this.category + ", pitch=" + this.pitch + ", volume=" + this.volume + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sound)) {
            return false;
        }
        Sound sound1 = (Sound)o;
        return Float.compare(this.getPitch(), sound1.getPitch()) == 0 && Float.compare(this.getVolume(), sound1.getVolume()) == 0 && Objects.equals(this.getSound(), sound1.getSound()) && this.getCategory() == sound1.getCategory();
    }

    public int hashCode() {
        return Objects.hash(this.getSound(), this.getCategory(), Float.valueOf(this.getPitch()), Float.valueOf(this.getVolume()));
    }

    public static Sound fromByteBuf(class_2540 buffer) {
        class_3414 sound = (class_3414)BookshelfByteBufs.SOUND_EVENT.read(buffer);
        class_3419 category = BookshelfByteBufs.SOUND_SOURCE.read(buffer);
        float pitch = BookshelfByteBufs.FLOAT.read(buffer).floatValue();
        float volume = BookshelfByteBufs.FLOAT.read(buffer).floatValue();
        return new Sound(sound, category, pitch, volume);
    }

    public static void toByteBuf(class_2540 buffer, Sound toWrite) {
        BookshelfByteBufs.SOUND_EVENT.write(buffer, toWrite.sound);
        BookshelfByteBufs.SOUND_SOURCE.write(buffer, toWrite.category);
        BookshelfByteBufs.FLOAT.write(buffer, Float.valueOf(toWrite.pitch));
        BookshelfByteBufs.FLOAT.write(buffer, Float.valueOf(toWrite.volume));
    }
}

