/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.darkhax.bookshelf.api.util.ItemStackHelper;
import net.darkhax.bookshelf.mixin.accessors.util.random.AccessorWeightedRandomList;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1889;
import net.minecraft.class_4516;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6862;

public class TestHelper {
    public static <T> void assertEqual(class_4516 helper, Optional<T> a, Optional<T> b, BiPredicate<T, T> equality) {
        if (a.isPresent() != b.isPresent()) {
            helper.method_35995("Optional values inconsistent. Original=" + a.isPresent() + " Result=" + b.isPresent());
            return;
        }
        if (a.isPresent() && b.isPresent() && !equality.test(a.get(), b.get())) {
            helper.method_35995("Optional values do not match. Original=" + a.get() + " Result=" + b.get());
            return;
        }
        helper.method_36036();
    }

    public static <T> void assertEqual(class_4516 helper, T[] a, T[] b, BiPredicate<T, T> equality) {
        if (a.length != b.length) {
            helper.method_35995("Arrays do not have the same size. Original=" + a.length + " Result=" + b.length);
        } else {
            for (int index = 0; index < a.length; ++index) {
                if (equality.test(a[index], b[index])) continue;
                helper.method_35995("List entry does not match! index=" + index + " a=" + a + " b=" + b);
                return;
            }
            helper.method_36036();
        }
    }

    public static boolean assertEqual(class_1889 a, class_1889 b) {
        return Objects.equals(a, b) || a.field_9093 == b.field_9093 && a.field_9094 == b.field_9094;
    }

    public static <T> boolean assertEqual(class_6862<T> a, class_6862<T> b) {
        return Objects.equals(a, b) || Objects.equals(a.comp_327(), b.comp_327());
    }

    public static boolean assertEqual(class_1856 original, class_1856 result) {
        class_1799[] resultStacks;
        if (Objects.equals(original, result)) {
            return true;
        }
        class_1799[] originalStacks = original.method_8105();
        if (originalStacks.length != (resultStacks = result.method_8105()).length) {
            return false;
        }
        for (int index = 0; index < originalStacks.length; ++index) {
            if (ItemStackHelper.areStacksEquivalent(originalStacks[index], resultStacks[index])) continue;
            return false;
        }
        return true;
    }

    public static <T> void assertEqual(class_4516 helper, class_6008.class_6010<T> original, class_6008.class_6010<T> result, BiPredicate<T, T> equality) {
        if (Objects.equals(original, result)) {
            helper.method_36036();
        } else if (original.method_34979().method_34976() != result.method_34979().method_34976()) {
            helper.method_35995("Weights do not match. a=" + original.method_34979() + " b=" + result.method_34979());
        } else if (!equality.test(original.method_34983(), result.method_34983())) {
            helper.method_35995("Weighted entries do not match. a=" + original.method_34983() + " b=" + result.method_34983());
        } else {
            helper.method_36036();
        }
    }

    public static <T> void assertEqual(class_4516 helper, class_6005<T> original, class_6005<T> result) {
        TestHelper.assertEqual(helper, original, result, Objects::equals);
    }

    public static <T> void assertEqual(class_4516 helper, class_6005<T> original, class_6005<T> result, BiPredicate<T, T> equality) {
        AccessorWeightedRandomList accessOriginal = (AccessorWeightedRandomList)original;
        AccessorWeightedRandomList accessResult = (AccessorWeightedRandomList)result;
        if (accessOriginal.bookshelf$getEntries().size() != accessResult.bookshelf$getEntries().size()) {
            helper.method_35995("Weighted lists do not have the same size. Original=" + accessOriginal.bookshelf$getEntries().size() + " Result=" + accessResult.bookshelf$getEntries().size());
        } else {
            for (int index = 0; index < accessOriginal.bookshelf$getEntries().size(); ++index) {
                class_6008.class_6010 a = (class_6008.class_6010)accessOriginal.bookshelf$getEntries().get(index);
                class_6008.class_6010 b = (class_6008.class_6010)accessResult.bookshelf$getEntries().get(index);
                if (a.method_34979().method_34976() != b.method_34979().method_34976()) {
                    helper.method_35995("Weighted list entry weights do not match! index=" + index + " a=" + a.method_34979().method_34976() + " b=" + b.method_34979().method_34976());
                    return;
                }
                if (equality.test(a.method_34983(), b.method_34983())) continue;
                helper.method_35995("Weighted list entry values do not match! index=" + index + " a=" + a.method_34983() + " b=" + b.method_34983());
                return;
            }
            helper.method_36036();
        }
    }

    public static <T> void assertEqual(class_4516 helper, Iterable<T> original, Iterable<T> result) {
        TestHelper.assertEqual(helper, original, result, Objects::equals);
    }

    public static <T> void assertEqual(class_4516 helper, Iterable<T> original, Iterable<T> result, BiPredicate<T, T> equality) {
        int resultSize;
        int originalSize = Iterables.size(original);
        if (originalSize != (resultSize = Iterables.size(result))) {
            helper.method_35995("Lists do not have the same size. Original=" + originalSize + " Result=" + resultSize);
        } else {
            for (int index = 0; index < originalSize; ++index) {
                Object b;
                Object a = Iterables.get(original, (int)index);
                if (equality.test(a, b = Iterables.get(result, (int)index))) continue;
                helper.method_35995("List entry does not match! index=" + index + " a=" + a + " b=" + b);
                return;
            }
            helper.method_36036();
        }
    }
}

