/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest.tests;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.TestHelper;
import net.minecraft.class_4516;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6302;

public class CodecTests<T>
implements ITestable {
    protected final String type;
    protected final CodecHelper<T> codecHelper;
    protected final T singleton;
    protected final T[] collection;
    protected final BiPredicate<T, T> equality;

    public CodecTests(String type, CodecHelper<T> serializer, T ... collection) {
        this(type, (CodecHelper<Object>)serializer, Objects::equals, (Object)collection[0], collection);
    }

    public CodecTests(String type, CodecHelper<T> codecHelper, BiPredicate<T, T> equality, T ... collection) {
        this(type, codecHelper, equality, collection[0], collection);
    }

    public CodecTests(String type, CodecHelper<T> codecHelper, BiPredicate<T, T> equality, T singleton, T ... collection) {
        this.type = type;
        this.codecHelper = codecHelper;
        this.equality = equality;
        this.singleton = singleton;
        this.collection = collection;
    }

    @class_6302
    public void test_singleton(class_4516 helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.get(), this.singleton);
        T fromJson = CodecTests.fromJson(helper, this.codecHelper.get(), toJson);
        if (!this.equality.test(this.singleton, fromJson)) {
            helper.method_35995("Deserialized singleton does not match input! a=" + this.singleton + " b=" + fromJson);
            return;
        }
        helper.method_36036();
    }

    @class_6302
    public void test_array(class_4516 helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getArray(), this.collection);
        T[] fromJson = CodecTests.fromJson(helper, this.codecHelper.getArray(), toJson);
        TestHelper.assertEqual(helper, this.collection, fromJson, this.equality);
    }

    @class_6302
    public void test_list(class_4516 helper) {
        List<T> inputList = Arrays.asList(this.collection);
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getList(), inputList);
        List<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getList(), toJson);
        if (fromJson.isEmpty()) {
            helper.method_35995("Found an empty list when non-empty was expected.");
        }
        TestHelper.assertEqual(helper, inputList, fromJson, this.equality);
    }

    @class_6302
    public void test_list_singleton(class_4516 helper) {
        List<T> inputList = List.of(this.singleton);
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getList(), inputList);
        List<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getList(), toJson);
        if (fromJson.isEmpty()) {
            helper.method_35995("Found an empty list when non-empty was expected.");
        }
        TestHelper.assertEqual(helper, inputList, fromJson, this.equality);
    }

    @class_6302
    public void test_list_empty(class_4516 helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getList(), new ArrayList());
        List<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getList(), toJson);
        if (!fromJson.isEmpty()) {
            helper.method_35995("Expected list to be empty. List=" + fromJson);
        } else {
            helper.method_36036();
        }
    }

    @class_6302
    public void test_set(class_4516 helper) {
        Set inputSet = Arrays.stream(this.collection).collect(Collectors.toSet());
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getSet(), inputSet);
        Set<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getSet(), toJson);
        TestHelper.assertEqual(helper, inputSet, fromJson, this.equality);
    }

    @class_6302
    public void test_optional(class_4516 helper) {
        Optional<T> input = Optional.of(this.singleton);
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getOptional("value"), input);
        Optional<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getOptional("value"), toJson);
        TestHelper.assertEqual(helper, input, fromJson, this.equality);
    }

    @class_6302
    public void test_optional_empty(class_4516 helper) {
        Optional input = Optional.empty();
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getOptional("value"), input);
        Optional<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getOptional("value"), toJson);
        TestHelper.assertEqual(helper, input, fromJson, this.equality);
    }

    @class_6302
    public void test_nullable(class_4516 helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getNullable("value"), this.singleton);
        T fromJson = CodecTests.fromJson(helper, this.codecHelper.getNullable("value"), toJson);
        if (!this.equality.test(this.singleton, fromJson)) {
            helper.method_35995("Deserialized singleton does not match input! a=" + this.singleton + " b=" + fromJson);
            return;
        }
        helper.method_36036();
    }

    @class_6302
    public void test_nullable_null(class_4516 helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getNullable("value"), null);
        T fromJson = CodecTests.fromJson(helper, this.codecHelper.getNullable("value"), toJson);
        if (!this.equality.test(null, fromJson)) {
            helper.method_35995("Deserialized singleton does not match input! a=null b=" + fromJson);
            return;
        }
        helper.method_36036();
    }

    @class_6302
    public void test_weighted(class_4516 helper) {
        class_6008.class_6010 input = class_6008.method_34980(this.singleton, (int)22);
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getWeighted(), input);
        class_6008.class_6010<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getWeighted(), toJson);
        TestHelper.assertEqual(helper, input, fromJson, this.equality);
    }

    @class_6302
    public void test_weighted_list(class_4516 helper) {
        class_6005.class_6006 builder = new class_6005.class_6006();
        for (int i = 0; i < this.collection.length; ++i) {
            builder.method_34975(this.collection[i], i * 4);
        }
        class_6005 input = builder.method_34974();
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getWeightedList(), input);
        class_6005<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getWeightedList(), toJson);
        TestHelper.assertEqual(helper, input, fromJson, this.equality);
    }

    @Override
    public String getDefaultBatch() {
        return "bookshelf.codecs." + this.type;
    }

    public static <DT> JsonElement toJson(class_4516 helper, MapCodec<DT> codec, DT data) {
        return (JsonElement)codec.encoder().encodeStart((DynamicOps)JsonOps.INSTANCE, data).getOrThrow(false, error -> helper.method_35995("Failed to serialize: " + error));
    }

    public static <DT> DT fromJson(class_4516 helper, MapCodec<DT> codec, JsonElement data) {
        return (DT)((Pair)codec.decoder().decode((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(false, error -> helper.method_35995("Failed to deserialize: " + error))).getFirst();
    }

    public static <DT> JsonElement toJson(class_4516 helper, Codec<DT> codec, DT data) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, data).getOrThrow(false, error -> helper.method_35995("Failed to serialize: " + error));
    }

    public static <DT> DT fromJson(class_4516 helper, Codec<DT> codec, JsonElement json) {
        return (DT)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, error -> helper.method_35995("Failed to deserialize: " + error))).getFirst();
    }
}

